/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.delivery;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Stack;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksConfigException;
import org.smooks.api.SmooksException;
import org.smooks.api.TypedKey;
import org.smooks.api.delivery.ContentDeliveryConfig;
import org.smooks.api.lifecycle.LifecycleManager;
import org.smooks.api.lifecycle.LifecyclePhase;
import org.smooks.api.resource.config.Parameter;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.api.resource.reader.JavaXMLReader;
import org.smooks.api.resource.reader.SmooksXMLReader;
import org.smooks.assertion.AssertArgument;
import org.smooks.engine.delivery.DOMReader;
import org.smooks.engine.injector.Scope;
import org.smooks.engine.lifecycle.PostConstructLifecyclePhase;
import org.smooks.engine.lookup.LifecycleManagerLookup;
import org.smooks.engine.resource.reader.NullSourceXMLReader;
import org.smooks.engine.resource.reader.XStreamXMLReader;
import org.smooks.engine.xml.NamespaceManager;
import org.smooks.io.DocumentInputSource;
import org.smooks.io.NullReader;
import org.smooks.io.payload.FilterSource;
import org.smooks.io.payload.JavaSource;
import org.smooks.namespace.NamespaceDeclarationStack;
import org.smooks.namespace.NamespaceDeclarationStackAware;
import org.smooks.support.ClassUtils;
import org.w3c.dom.Document;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.helpers.XMLReaderFactory;

public class AbstractParser {
    public static final String ORG_XML_SAX_DRIVER = "org.xml.sax.driver";
    public static final String FEATURE_ON = "feature-on";
    public static final String FEATURE_OFF = "feature-off";
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractParser.class);
    private static final TypedKey<Stack<XMLReader>> XML_READER_STACK_TYPED_KEY = TypedKey.of();
    private final ExecutionContext executionContext;
    private final ResourceConfig saxDriverConfig;

    public AbstractParser(ExecutionContext executionContext, ResourceConfig saxDriverConfig) {
        AssertArgument.isNotNull(executionContext, "executionContext");
        this.executionContext = executionContext;
        this.saxDriverConfig = saxDriverConfig;
    }

    public AbstractParser(ExecutionContext executionContext) {
        this(executionContext, AbstractParser.getSAXParserConfiguration(executionContext.getContentDeliveryRuntime().getContentDeliveryConfig()));
    }

    protected ExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    protected ResourceConfig getSaxDriverConfig() {
        return this.saxDriverConfig;
    }

    public static void attachXMLReader(XMLReader xmlReader, ExecutionContext execContext) {
        AbstractParser.getReaders(execContext).push(xmlReader);
        NamespaceDeclarationStack namespaceDeclarationStack = execContext.get(NamespaceManager.NAMESPACE_DECLARATION_STACK_TYPED_KEY);
        if (namespaceDeclarationStack == null) {
            throw new IllegalStateException("No NamespaceDeclarationStack attached to the ExecutionContext.");
        }
        namespaceDeclarationStack.pushReader(xmlReader);
    }

    public static XMLReader getXMLReader(ExecutionContext executionContext) {
        Stack<XMLReader> xmlReaderStack = AbstractParser.getReaders(executionContext);
        if (!xmlReaderStack.isEmpty()) {
            return xmlReaderStack.peek();
        }
        return null;
    }

    public static void detachXMLReader(ExecutionContext executionContext) {
        Stack<XMLReader> xmlReaderStack = AbstractParser.getReaders(executionContext);
        if (!xmlReaderStack.isEmpty()) {
            xmlReaderStack.pop();
            executionContext.get(NamespaceManager.NAMESPACE_DECLARATION_STACK_TYPED_KEY).popReader();
        }
    }

    public static Stack<XMLReader> getReaders(ExecutionContext executionContext) {
        Stack<XMLReader> readers = executionContext.get(XML_READER_STACK_TYPED_KEY);
        if (readers == null) {
            readers = new Stack();
            AbstractParser.setReaders(readers, executionContext);
        }
        return readers;
    }

    public static void setReaders(Stack<XMLReader> readers, ExecutionContext executionContext) {
        executionContext.put(XML_READER_STACK_TYPED_KEY, readers);
    }

    public static ResourceConfig getSAXParserConfiguration(ContentDeliveryConfig deliveryConfig) {
        if (deliveryConfig == null) {
            throw new IllegalArgumentException("null 'deliveryConfig' arg in method call.");
        }
        ResourceConfig saxDriverConfig = null;
        List<ResourceConfig> saxConfigs = deliveryConfig.getResourceConfigs(ORG_XML_SAX_DRIVER);
        if (saxConfigs != null && !saxConfigs.isEmpty()) {
            saxDriverConfig = saxConfigs.get(0);
        }
        return saxDriverConfig;
    }

    private static Reader systemIdToReader(String systemId, String contentEncoding) {
        return AbstractParser.streamToReader(AbstractParser.systemIdToStream(systemId), contentEncoding);
    }

    private static InputStream systemIdToStream(String systemId) {
        try {
            return AbstractParser.systemIdToURL(systemId).openStream();
        }
        catch (IOException e) {
            throw new SmooksException("Invalid System ID on StreamSource: '" + systemId + "'.  Unable to open stream to resource.", e);
        }
    }

    private static URL systemIdToURL(String systemId) {
        try {
            return new URL(systemId);
        }
        catch (MalformedURLException e) {
            throw new SmooksException("Invalid System ID on StreamSource: '" + systemId + "'.  Must be a valid URL.", e);
        }
    }

    private static Reader streamToReader(InputStream inputStream, String contentEncoding) {
        try {
            if (contentEncoding != null) {
                return new InputStreamReader(inputStream, contentEncoding);
            }
            return new InputStreamReader(inputStream, StandardCharsets.UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            throw new SmooksException("Unable to decode input stream.", e);
        }
    }

    protected InputSource createInputSource(Source source, String contentEncoding) {
        if (source instanceof StreamSource) {
            StreamSource streamSource = (StreamSource)source;
            InputStream inputStream = this.getInputStream(streamSource);
            Reader reader = streamSource.getReader();
            if (reader == null) {
                if (inputStream == null) {
                    throw new SmooksException("Invalid StreamSource. Unable to extract an InputStream (even by systemId) or Reader instance.");
                }
                reader = AbstractParser.streamToReader(inputStream, contentEncoding);
            }
            InputSource inputSource = new InputSource();
            inputSource.setByteStream(inputStream);
            inputSource.setCharacterStream(reader);
            return inputSource;
        }
        if (source instanceof DOMSource) {
            return new DocumentInputSource((Document)((DOMSource)source).getNode());
        }
        if (source.getSystemId() != null) {
            return new InputSource(AbstractParser.systemIdToReader(source.getSystemId(), contentEncoding));
        }
        return new InputSource(new NullReader());
    }

    protected InputStream getInputStream(StreamSource streamSource) {
        InputStream inputStream = streamSource.getInputStream();
        String systemId = streamSource.getSystemId();
        if (inputStream != null) {
            return inputStream;
        }
        if (systemId != null) {
            return AbstractParser.systemIdToStream(systemId);
        }
        return null;
    }

    protected XMLReader createXMLReader() throws SAXException {
        XMLReader xmlReader;
        Source source = FilterSource.getSource(this.executionContext);
        if (this.saxDriverConfig != null && this.saxDriverConfig.getResource() != null) {
            xmlReader = XMLReaderFactory.createXMLReader(this.saxDriverConfig.getResource());
        } else if (source instanceof JavaSource) {
            boolean eventStreamingOn;
            JavaSource javaSource = (JavaSource)source;
            if (AbstractParser.isFeatureOn("http://www.smooks.org/sax/features/generate-java-event-stream", this.saxDriverConfig) && !javaSource.isEventStreamRequired()) {
                throw new SmooksConfigException(String.format("Invalid Smooks configuration. Feature [%s] is explicitly configured 'on' in the Smooks configuration, while the supplied JavaSource has explicitly configured event streaming to be off (through a call to JavaSource.setEventStreamRequired).", "http://www.smooks.org/sax/features/generate-java-event-stream"));
            }
            boolean bl = eventStreamingOn = !AbstractParser.isFeatureOff("http://www.smooks.org/sax/features/generate-java-event-stream", this.saxDriverConfig) && javaSource.isEventStreamRequired();
            xmlReader = eventStreamingOn && javaSource.getSourceObjects() != null ? new XStreamXMLReader() : new NullSourceXMLReader();
        } else {
            xmlReader = source instanceof DOMSource ? new DOMReader() : XMLReaderFactory.createXMLReader();
        }
        if (xmlReader instanceof SmooksXMLReader) {
            LifecycleManager lifecycleManager = this.executionContext.getApplicationContext().getRegistry().lookup(new LifecycleManagerLookup());
            if (this.saxDriverConfig != null) {
                lifecycleManager.applyPhase(xmlReader, (LifecyclePhase)new PostConstructLifecyclePhase(new Scope(this.executionContext.getApplicationContext().getRegistry(), this.saxDriverConfig, xmlReader)));
            } else {
                lifecycleManager.applyPhase(xmlReader, (LifecyclePhase)new PostConstructLifecyclePhase());
            }
        }
        xmlReader.setFeature("http://xml.org/sax/features/namespaces", true);
        xmlReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        this.setHandlers(xmlReader);
        this.setFeatures(xmlReader);
        return xmlReader;
    }

    protected void attachNamespaceDeclarationStack(XMLReader reader, ExecutionContext execContext) {
        if (reader instanceof NamespaceDeclarationStackAware) {
            NamespaceDeclarationStack nsDeclarationStack = execContext.get(NamespaceManager.NAMESPACE_DECLARATION_STACK_TYPED_KEY);
            if (nsDeclarationStack == null) {
                throw new IllegalStateException("NamespaceDeclarationStack not configured on ExecutionContext.");
            }
            ((NamespaceDeclarationStackAware)((Object)reader)).setNamespaceDeclarationStack(nsDeclarationStack);
        }
    }

    protected void configureReader(XMLReader xmlReader, DefaultHandler2 contentHandler, ExecutionContext executionContext, Source source) throws SAXException {
        if (xmlReader instanceof SmooksXMLReader) {
            ((SmooksXMLReader)xmlReader).setExecutionContext(executionContext);
        }
        if (xmlReader instanceof JavaXMLReader) {
            if (!(source instanceof JavaSource)) {
                throw new SmooksException("A " + JavaSource.class.getName() + " source must be supplied for " + JavaXMLReader.class.getName() + " implementations.");
            }
            ((JavaXMLReader)xmlReader).setSourceObjects(((JavaSource)source).getSourceObjects());
        }
        xmlReader.setContentHandler(contentHandler);
        try {
            xmlReader.setProperty("http://xml.org/sax/properties/lexical-handler", contentHandler);
        }
        catch (SAXNotRecognizedException e) {
            LOGGER.warn("XMLReader property 'http://xml.org/sax/properties/lexical-handler' not recognized by XMLReader '" + xmlReader.getClass().getName() + "'.");
        }
    }

    private void setHandlers(XMLReader reader) {
        List<Parameter<?>> handlers;
        if (this.saxDriverConfig != null && (handlers = this.saxDriverConfig.getParameters("sax-handler")) != null) {
            for (Parameter<?> handler : handlers) {
                Object handlerObj = this.createHandler((String)handler.getValue());
                if (handlerObj instanceof EntityResolver) {
                    reader.setEntityResolver((EntityResolver)handlerObj);
                }
                if (handlerObj instanceof DTDHandler) {
                    reader.setDTDHandler((DTDHandler)handlerObj);
                }
                if (!(handlerObj instanceof ErrorHandler)) continue;
                reader.setErrorHandler((ErrorHandler)handlerObj);
            }
        }
    }

    private Object createHandler(String handlerName) {
        try {
            return ClassUtils.forName(handlerName, this.getClass()).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new SmooksException("Failed to create SAX Handler '" + handlerName + "'.", e);
        }
    }

    private void setFeatures(XMLReader reader) throws SAXNotSupportedException, SAXNotRecognizedException {
        try {
            reader.setFeature("http://apache.org/xml/features/scanner/notify-char-refs", true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            reader.setFeature("http://xml.org/sax/features/xmlns-uris", true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.saxDriverConfig != null) {
            List<Parameter<?>> features = this.saxDriverConfig.getParameters(FEATURE_ON);
            if (features != null) {
                for (Parameter<?> feature : features) {
                    reader.setFeature((String)feature.getValue(), true);
                }
            }
            if ((features = this.saxDriverConfig.getParameters(FEATURE_OFF)) != null) {
                for (Parameter<?> feature : features) {
                    reader.setFeature((String)feature.getValue(), false);
                }
            }
        }
    }

    public static boolean isFeatureOn(String name, ResourceConfig saxDriverConfig) {
        boolean featureOn = AbstractParser.isFeature(name, FeatureValue.ON, saxDriverConfig);
        if (featureOn && AbstractParser.isFeature(name, FeatureValue.OFF, saxDriverConfig)) {
            throw new SmooksException("Invalid Smooks configuration.  Feature '" + name + "' is explicitly configured 'on' and 'off'.  Must be one or the other!");
        }
        return featureOn;
    }

    public static boolean isFeatureOff(String name, ResourceConfig saxDriverConfig) {
        boolean featureOff = AbstractParser.isFeature(name, FeatureValue.OFF, saxDriverConfig);
        if (featureOff && AbstractParser.isFeature(name, FeatureValue.ON, saxDriverConfig)) {
            throw new SmooksException("Invalid Smooks configuration.  Feature '" + name + "' is explicitly configured 'on' and 'off'.  Must be one or the other!");
        }
        return featureOff;
    }

    private static boolean isFeature(String name, FeatureValue featureValue, ResourceConfig saxDriverConfig) {
        List<Parameter<?>> features;
        if (saxDriverConfig != null && (features = featureValue == FeatureValue.ON ? saxDriverConfig.getParameters(FEATURE_ON) : saxDriverConfig.getParameters(FEATURE_OFF)) != null) {
            for (Parameter<?> feature : features) {
                if (!feature.getValue().equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    private static enum FeatureValue {
        ON,
        OFF;

    }
}

