/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.delivery;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.inject.Inject;
import org.smooks.api.ApplicationContext;
import org.smooks.api.SmooksConfigException;
import org.smooks.api.SmooksException;
import org.smooks.api.delivery.ContentHandlerFactory;
import org.smooks.api.lifecycle.LifecyclePhase;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.engine.injector.Scope;
import org.smooks.engine.lifecycle.PostConstructLifecyclePhase;
import org.smooks.engine.lookup.LifecycleManagerLookup;
import org.smooks.engine.resource.config.DefaultResourceConfig;
import org.smooks.support.ClassUtils;

public class JavaContentHandlerFactory
implements ContentHandlerFactory<Object> {
    @Inject
    private ApplicationContext applicationContext;

    @Override
    public Object create(ResourceConfig resourceConfig) throws SmooksConfigException {
        Object contentHandler;
        try {
            String className = ClassUtils.toClassName(resourceConfig.getResource());
            Class<?> classRuntime = ClassUtils.forName(className, this.getClass());
            try {
                Constructor<?> constructor = classRuntime.getConstructor(DefaultResourceConfig.class);
                contentHandler = constructor.newInstance(resourceConfig);
            }
            catch (NoSuchMethodException e) {
                contentHandler = classRuntime.newInstance();
            }
            this.applicationContext.getRegistry().lookup(new LifecycleManagerLookup()).applyPhase(contentHandler, (LifecyclePhase)new PostConstructLifecyclePhase(new Scope(this.applicationContext.getRegistry(), resourceConfig, contentHandler)));
            this.applicationContext.getRegistry().registerObject(contentHandler);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new SmooksException("Failed to create an instance of Java ContentHandler [" + resourceConfig.getResource() + "].  See exception cause...", e);
        }
        return contentHandler;
    }

    @Override
    public String getType() {
        return "class";
    }
}

