/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.delivery.dom;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.smooks.api.Registry;
import org.smooks.api.delivery.ContentHandler;
import org.smooks.api.delivery.ContentHandlerBinding;
import org.smooks.api.delivery.event.ContentDeliveryConfigExecutionEvent;
import org.smooks.api.lifecycle.PostFragmentLifecycle;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.api.resource.config.xpath.SelectorStep;
import org.smooks.api.resource.visitor.SerializerVisitor;
import org.smooks.api.resource.visitor.Visitor;
import org.smooks.api.resource.visitor.dom.DOMVisitAfter;
import org.smooks.api.resource.visitor.dom.DOMVisitBefore;
import org.smooks.api.resource.visitor.dom.Phase;
import org.smooks.api.resource.visitor.dom.VisitPhase;
import org.smooks.engine.delivery.AbstractFilterProvider;
import org.smooks.engine.delivery.dom.DOMContentDeliveryConfig;
import org.smooks.engine.delivery.dom.serialize.DOMSerializerVisitor;
import org.smooks.engine.delivery.event.DefaultContentDeliveryConfigExecutionEvent;
import org.smooks.engine.lookup.NamespaceManagerLookup;
import org.smooks.engine.resource.config.ParameterAccessor;
import org.smooks.engine.resource.config.xpath.step.ElementSelectorStep;

public class DOMFilterProvider
extends AbstractFilterProvider {
    @Override
    public DOMContentDeliveryConfig createContentDeliveryConfig(List<ContentHandlerBinding<Visitor>> visitorBindings, Registry registry, Map<String, List<ResourceConfig>> resourceConfigTable, List<ContentDeliveryConfigExecutionEvent> contentDeliveryConfigExecutionEvents) {
        DOMContentDeliveryConfig domConfig = new DOMContentDeliveryConfig();
        for (ContentHandlerBinding<Visitor> contentHandlerBinding : visitorBindings) {
            String targetElement = null;
            for (int i = contentHandlerBinding.getResourceConfig().getSelectorPath().size(); i > 0; --i) {
                SelectorStep selectorStep = (SelectorStep)contentHandlerBinding.getResourceConfig().getSelectorPath().get(i - 1);
                if (!(selectorStep instanceof ElementSelectorStep)) continue;
                targetElement = ((ElementSelectorStep)selectorStep).getQName().getLocalPart();
                break;
            }
            Visitor visitor = contentHandlerBinding.getContentHandler();
            ResourceConfig resourceConfig = contentHandlerBinding.getResourceConfig();
            resourceConfig.getSelectorPath().setNamespaces(registry.lookup(new NamespaceManagerLookup()).orElse(new Properties()));
            if (this.isDOMVisitor(visitor)) {
                if (visitor instanceof DOMSerializerVisitor) {
                    domConfig.getSerializerVisitorIndex().put(targetElement, resourceConfig, (SerializerVisitor)visitor);
                    contentDeliveryConfigExecutionEvents.add(new DefaultContentDeliveryConfigExecutionEvent(resourceConfig, "Added as a DOM " + SerializerVisitor.class.getSimpleName() + " resource."));
                } else {
                    Phase phaseAnnotation = contentHandlerBinding.getContentHandler().getClass().getAnnotation(Phase.class);
                    String visitPhase = resourceConfig.getParameterValue("VisitPhase", String.class, VisitPhase.PROCESSING.toString());
                    if (phaseAnnotation != null && phaseAnnotation.value() == VisitPhase.ASSEMBLY) {
                        if (visitor instanceof DOMVisitBefore && this.visitBeforeAnnotationsOK(visitor)) {
                            domConfig.getAssemblyVisitBeforeIndex().put(targetElement, resourceConfig, (DOMVisitBefore)visitor);
                        }
                        if (visitor instanceof DOMVisitAfter && this.visitAfterAnnotationsOK(visitor)) {
                            domConfig.getAssemblyVisitAfterIndex().put(targetElement, resourceConfig, (DOMVisitAfter)visitor);
                        }
                    } else if (visitPhase.equalsIgnoreCase(VisitPhase.ASSEMBLY.toString())) {
                        if (visitor instanceof DOMVisitBefore && this.visitBeforeAnnotationsOK(visitor)) {
                            domConfig.getAssemblyVisitBeforeIndex().put(targetElement, resourceConfig, (DOMVisitBefore)visitor);
                        }
                        if (visitor instanceof DOMVisitAfter && this.visitAfterAnnotationsOK(visitor)) {
                            domConfig.getAssemblyVisitAfterIndex().put(targetElement, resourceConfig, (DOMVisitAfter)visitor);
                        }
                    } else {
                        if (visitor instanceof DOMVisitBefore && this.visitBeforeAnnotationsOK(visitor)) {
                            domConfig.getProcessingVisitBeforeIndex().put(targetElement, resourceConfig, (DOMVisitBefore)visitor);
                        }
                        if (visitor instanceof DOMVisitAfter && this.visitAfterAnnotationsOK(visitor)) {
                            domConfig.getProcessingVisitAfterIndex().put(targetElement, resourceConfig, (DOMVisitAfter)visitor);
                        }
                    }
                    contentDeliveryConfigExecutionEvents.add(new DefaultContentDeliveryConfigExecutionEvent(resourceConfig, "Added as a DOM " + visitPhase + " Phase resource."));
                }
            }
            if (!(visitor instanceof PostFragmentLifecycle)) continue;
            domConfig.getPostFragmentLifecycleIndex().put(targetElement, resourceConfig, (PostFragmentLifecycle)visitor);
        }
        domConfig.setRegistry(registry);
        domConfig.setResourceConfigs(resourceConfigTable);
        domConfig.getContentDeliveryConfigExecutionEvents().addAll(contentDeliveryConfigExecutionEvents);
        if (ParameterAccessor.getParameterValue("smooks.visitors.sort", Boolean.class, Boolean.valueOf(true), resourceConfigTable).booleanValue()) {
            domConfig.sort();
        }
        domConfig.addToExecutionLifecycleSets();
        domConfig.configureFilterBypass();
        return domConfig;
    }

    @Override
    public Boolean isProvider(List<ContentHandlerBinding<Visitor>> visitorBindings) {
        return visitorBindings.stream().filter(c -> this.isDOMVisitor((ContentHandler)c.getContentHandler())).count() == visitorBindings.stream().count();
    }

    @Override
    public String getName() {
        return "DOM";
    }

    protected boolean isDOMVisitor(ContentHandler contentHandler) {
        return contentHandler instanceof DOMVisitBefore || contentHandler instanceof DOMVisitAfter || contentHandler instanceof DOMSerializerVisitor;
    }
}

