/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.delivery.event;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smooks.api.ExecutionContext;
import org.smooks.api.delivery.ContentHandlerBinding;
import org.smooks.api.delivery.event.ResourceAwareEvent;
import org.smooks.api.delivery.fragment.Fragment;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.api.resource.visitor.VisitAfterReport;
import org.smooks.api.resource.visitor.VisitBeforeReport;
import org.smooks.api.resource.visitor.Visitor;
import org.smooks.engine.delivery.event.FragmentExecutionEvent;
import org.smooks.engine.delivery.event.VisitSequence;
import org.smooks.engine.expression.MVELExpressionEvaluator;
import org.smooks.support.FreeMarkerTemplate;
import org.smooks.support.MultiLineToStringBuilder;

public class VisitExecutionEvent<F, T extends Visitor>
extends FragmentExecutionEvent<F>
implements ResourceAwareEvent {
    private static final Logger LOGGER = LoggerFactory.getLogger(VisitExecutionEvent.class);
    private final ContentHandlerBinding<T> visitorBinding;
    private final VisitSequence sequence;
    private final ExecutionContext executionContext;
    private String executionContextState;
    private Throwable error;
    private String reportSummary;
    private String reportDetail;

    public VisitExecutionEvent(Fragment<F> fragment, ContentHandlerBinding<T> visitorBinding, VisitSequence sequence, ExecutionContext executionContext) {
        super(fragment);
        this.visitorBinding = visitorBinding;
        this.sequence = sequence;
        this.executionContext = executionContext;
    }

    public VisitExecutionEvent(Fragment<F> fragment, ContentHandlerBinding<T> visitorBinding, VisitSequence sequence, ExecutionContext executionContext, Throwable error) {
        this(fragment, visitorBinding, sequence, executionContext);
        this.error = error;
    }

    @Override
    public ResourceConfig getResourceConfig() {
        return this.visitorBinding.getResourceConfig();
    }

    public ContentHandlerBinding<T> getVisitorBinding() {
        return this.visitorBinding;
    }

    public VisitSequence getSequence() {
        return this.sequence;
    }

    public String getExecutionContextState() {
        if (this.executionContextState == null) {
            try {
                this.executionContextState = MultiLineToStringBuilder.toString(this.executionContext);
            }
            catch (Exception e) {
                StringWriter exceptionWriter = new StringWriter();
                e.printStackTrace(new PrintWriter(exceptionWriter));
                this.executionContextState = "Execution Context Serialization Failure:\n" + exceptionWriter.toString();
            }
        }
        return this.executionContextState;
    }

    public Throwable getError() {
        return this.error;
    }

    public String getReportSummary() {
        if (this.reportSummary == null) {
            this.initReport(this.executionContext);
        }
        return this.reportSummary;
    }

    public String getReportDetail() {
        if (this.reportDetail == null) {
            this.initReport(this.executionContext);
        }
        return this.reportDetail;
    }

    private void initReport(ExecutionContext executionContext) {
        T handler = this.visitorBinding.getContentHandler();
        if (this.getSequence() == VisitSequence.BEFORE) {
            VisitBeforeReport reportAnnotation = handler.getClass().getAnnotation(VisitBeforeReport.class);
            if (reportAnnotation != null && this.evalReportCondition(reportAnnotation.condition())) {
                this.applyReportTemplates(reportAnnotation.summary(), reportAnnotation.detailTemplate(), handler.getClass(), executionContext);
            }
        } else {
            VisitAfterReport reportAnnotation = handler.getClass().getAnnotation(VisitAfterReport.class);
            if (reportAnnotation != null && this.evalReportCondition(reportAnnotation.condition())) {
                this.applyReportTemplates(reportAnnotation.summary(), reportAnnotation.detailTemplate(), handler.getClass(), executionContext);
            }
        }
        if (this.reportDetail == null) {
            this.reportDetail = this.getExecutionContextState();
        }
    }

    private boolean evalReportCondition(String condition) {
        MVELExpressionEvaluator conditionEval = new MVELExpressionEvaluator();
        conditionEval.setExpression(condition);
        return conditionEval.eval(this.visitorBinding.getResourceConfig());
    }

    private void applyReportTemplates(String summary, String detailTemplate, Class<?> handlerClass, ExecutionContext executionContext) {
        FreeMarkerTemplate template;
        HashMap<String, Object> templateParams = new HashMap<String, Object>();
        templateParams.put("resource", this.visitorBinding.getResourceConfig());
        templateParams.put("execContext", executionContext);
        templateParams.put("event", this);
        if (!summary.equals("##NULL")) {
            template = new FreeMarkerTemplate(summary);
            try {
                this.reportSummary = template.apply(templateParams);
            }
            catch (Exception e) {
                this.reportSummary = "Report Template Summary Error: " + e.getMessage();
                LOGGER.warn("Failed to apply Summary Template.", (Throwable)e);
            }
        }
        if (!detailTemplate.equals("##NULL")) {
            template = new FreeMarkerTemplate(detailTemplate, handlerClass);
            try {
                this.reportDetail = template.apply(templateParams);
            }
            catch (Exception e) {
                this.reportSummary = "Report Template Detail Error: " + e.getMessage();
                LOGGER.warn("Failed to apply Detail Template.", (Throwable)e);
            }
        }
    }
}

