/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.delivery.sax.ng;

import java.io.IOException;
import java.io.Writer;
import java.util.Optional;
import java.util.function.Consumer;
import javax.inject.Inject;
import javax.inject.Named;
import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksException;
import org.smooks.api.delivery.fragment.Fragment;
import org.smooks.api.memento.Memento;
import org.smooks.api.resource.visitor.Visitor;
import org.smooks.api.resource.visitor.dom.DOMElementVisitor;
import org.smooks.engine.delivery.fragment.NodeFragment;
import org.smooks.engine.delivery.sax.ng.SaxNgContentDeliveryConfig;
import org.smooks.engine.delivery.sax.ng.SimpleSerializerVisitor;
import org.smooks.engine.memento.AbstractVisitorMemento;
import org.smooks.engine.memento.SimpleVisitorMemento;
import org.smooks.engine.memento.VisitorMemento;
import org.smooks.io.FragmentWriter;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ConsumeSerializerVisitor
extends SimpleSerializerVisitor
implements DOMElementVisitor {
    protected Boolean closeEmptyElements = true;

    @Inject
    public void setCloseEmptyElements(@Named(value="close.empty.elements") Optional<Boolean> closeEmptyElements) {
        this.closeEmptyElements = closeEmptyElements.orElse(this.closeEmptyElements);
    }

    public void writeStartElement(Element element, ExecutionContext executionContext) {
        NodeFragment nodeFragment = new NodeFragment(element);
        executionContext.getMementoCaretaker().stash(new ElementMemento(nodeFragment, this, false), elementMemento -> {
            if (!elementMemento.isOpen().booleanValue()) {
                try {
                    this.writeStartElement(element, new FragmentWriter(executionContext, nodeFragment), executionContext);
                }
                catch (IOException e) {
                    throw new SmooksException(e.getMessage(), e);
                }
                return new ElementMemento(nodeFragment, this, true);
            }
            return elementMemento;
        });
    }

    protected void closeElement(Element element, Writer writer, ExecutionContext executionContext) {
        ElementMemento elementMemento = new ElementMemento(new NodeFragment(element), this, false);
        executionContext.getMementoCaretaker().restore(elementMemento);
        try {
            if (this.closeEmptyElements.booleanValue() && !elementMemento.isOpen().booleanValue()) {
                writer.write(60);
                writer.write(element.getTagName());
                this.domSerializer.writeAttributes(element.getAttributes(), writer);
                writer.write("/>");
            } else {
                if (!elementMemento.isOpen().booleanValue()) {
                    this.writeStartElement(element, executionContext);
                }
                writer.write("</");
                writer.write(element.getTagName());
                writer.write(62);
            }
            writer.flush();
        }
        catch (IOException e) {
            throw new SmooksException(e.getMessage(), e);
        }
    }

    @Override
    public void visitBefore(Element element, ExecutionContext executionContext) throws SmooksException {
    }

    @Override
    public void visitChildText(CharacterData characterData, ExecutionContext executionContext) throws SmooksException {
        this.onWrite(nodeWriter -> {
            executionContext.getMementoCaretaker().stash(new ElementMemento(new NodeFragment(characterData.getParentNode()), this, false), elementMemento -> {
                if (!elementMemento.isOpen().booleanValue()) {
                    try {
                        this.writeStartElement((Element)characterData.getParentNode(), (Writer)nodeWriter, executionContext);
                    }
                    catch (IOException e) {
                        throw new SmooksException(e);
                    }
                    return new ElementMemento(new NodeFragment(characterData.getParentNode()), this, true);
                }
                return elementMemento;
            });
            try {
                FragmentWriter charDataWriter = new FragmentWriter(executionContext, new NodeFragment(characterData));
                this.domSerializer.writeCharacterData(characterData, charDataWriter);
                ((Writer)charDataWriter).flush();
            }
            catch (IOException e) {
                throw new SmooksException(e.getMessage(), e);
            }
        }, executionContext, characterData.getParentNode());
    }

    @Override
    public void visitChildElement(Element childElement, ExecutionContext executionContext) throws SmooksException {
        Element parentElement = (Element)childElement.getParentNode();
        this.onWrite(nodeWriter -> executionContext.getMementoCaretaker().stash(new ElementMemento(new NodeFragment(parentElement), this, false), elementMemento -> {
            if (!elementMemento.isOpen().booleanValue()) {
                try {
                    this.writeStartElement(parentElement, (Writer)nodeWriter, executionContext);
                    nodeWriter.flush();
                }
                catch (IOException e) {
                    throw new SmooksException(e);
                }
                return new ElementMemento(new NodeFragment(parentElement), this, true);
            }
            return elementMemento;
        }), executionContext, childElement.getParentNode());
    }

    @Override
    public void visitAfter(Element element, ExecutionContext executionContext) throws SmooksException {
        this.onWrite(nodeWriter -> this.closeElement(element, (Writer)nodeWriter, executionContext), executionContext, element);
    }

    protected void onWrite(Consumer<Writer> writerConsumer, ExecutionContext executionContext, Node node) {
        if (executionContext.getContentDeliveryRuntime().getContentDeliveryConfig() instanceof SaxNgContentDeliveryConfig) {
            NodeFragment nodeFragment = new NodeFragment(node);
            VisitorMemento fragmentWriterMemento = executionContext.getMementoCaretaker().stash(new SimpleVisitorMemento<FragmentWriter>(nodeFragment, (Visitor)this, new FragmentWriter(executionContext, nodeFragment)), restoredFragmentWriterMemento -> restoredFragmentWriterMemento);
            writerConsumer.accept((Writer)fragmentWriterMemento.getState());
        }
    }

    protected static class ElementMemento
    extends AbstractVisitorMemento {
        private Boolean isOpen;

        public ElementMemento(Fragment<?> fragment, Visitor visitor, Boolean isOpen) {
            super(fragment, visitor);
            this.isOpen = isOpen;
        }

        @Override
        public Memento copy() {
            return new ElementMemento(this.fragment, this.visitor, this.isOpen);
        }

        @Override
        public void restore(Memento memento) {
            this.isOpen = ((ElementMemento)memento).isOpen();
        }

        public Boolean isOpen() {
            return this.isOpen;
        }
    }
}

