/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.delivery.sax.ng;

import java.io.StringReader;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksException;
import org.smooks.engine.delivery.AbstractFilter;
import org.smooks.engine.delivery.sax.ng.SaxNgParser;
import org.smooks.engine.delivery.sax.ng.terminate.TerminateException;
import org.smooks.io.Stream;
import org.smooks.io.payload.FilterResult;
import org.smooks.io.payload.FilterSource;
import org.smooks.io.payload.JavaSource;
import org.smooks.support.DomUtils;
import org.smooks.support.XmlUtils;

public class SaxNgFilter
extends AbstractFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SaxNgFilter.class);
    protected final ExecutionContext executionContext;
    protected final boolean closeSource;
    protected final boolean closeResult;
    protected final SaxNgParser parser;

    public SaxNgFilter(ExecutionContext executionContext, DocumentBuilder documentBuilder, boolean closeSource, boolean closeResult) {
        this.executionContext = executionContext;
        this.closeSource = closeSource;
        this.closeResult = closeResult;
        this.parser = new SaxNgParser(executionContext, documentBuilder);
    }

    @Override
    public void doFilter() throws SmooksException {
        Source source = FilterSource.getSource(this.executionContext);
        Result result = FilterResult.getResult(this.executionContext, StreamResult.class);
        if (result == null) {
            result = FilterResult.getResult(this.executionContext, DOMResult.class);
        }
        this.doFilter(source, result);
    }

    protected void doFilter(Source source, Result result) {
        if (!(source instanceof StreamSource || source instanceof JavaSource || source instanceof DOMSource)) {
            throw new SmooksException(String.format("Unsupported [%s] source type: SAX NG filter supports StreamSource, JavaSource, and DOMSource", source.getClass().getName()));
        }
        if (!(result instanceof FilterResult || result == null || result instanceof StreamResult || result instanceof DOMResult)) {
            throw new SmooksException(String.format("Unsupported [%s] result type: SAX NG filter supports StreamResult and DOMResult", result.getClass().getName()));
        }
        try {
            Writer writer = this.getWriter(result, this.executionContext);
            this.executionContext.put(Stream.STREAM_WRITER_TYPED_KEY, writer);
            this.parser.parse(source, this.executionContext);
            if (result instanceof DOMResult) {
                ((DOMResult)result).setNode(XmlUtils.parseStream(new StringReader(writer.toString())));
            } else {
                writer.flush();
            }
        }
        catch (TerminateException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Terminated filtering on element {}", (Object)DomUtils.getXPath(e.getElement()));
            }
        }
        catch (Exception e) {
            throw new SmooksException("Failed to filter source", e);
        }
        finally {
            if (this.closeSource) {
                this.close(source);
            }
            if (this.closeResult) {
                this.close(result);
            }
        }
    }

    @Override
    public void close() {
        this.parser.close();
    }
}

