/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.delivery.sax.ng.org.apache.xerces.impl.dv.xs;

import javax.xml.datatype.XMLGregorianCalendar;
import org.smooks.engine.delivery.sax.ng.org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.smooks.engine.delivery.sax.ng.org.apache.xerces.impl.dv.ValidationContext;
import org.smooks.engine.delivery.sax.ng.org.apache.xerces.impl.dv.xs.AbstractDateTimeDV;
import org.smooks.engine.delivery.sax.ng.org.apache.xerces.impl.dv.xs.SchemaDateTimeException;

public class YearDV
extends AbstractDateTimeDV {
    @Override
    public Object getActualValue(String content, ValidationContext context) throws InvalidDatatypeValueException {
        try {
            return this.parse(content);
        }
        catch (Exception ex) {
            throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{content, "gYear"});
        }
    }

    protected AbstractDateTimeDV.DateTimeData parse(String str) throws SchemaDateTimeException {
        int sign;
        int length;
        AbstractDateTimeDV.DateTimeData date = new AbstractDateTimeDV.DateTimeData(str, this);
        int len = str.length();
        int start = 0;
        if (str.charAt(0) == '-') {
            start = 1;
        }
        if ((length = ((sign = this.findUTCSign(str, start, len)) == -1 ? len : sign) - start) < 4) {
            throw new RuntimeException("Year must have 'CCYY' format");
        }
        if (length > 4 && str.charAt(start) == '0') {
            throw new RuntimeException("Leading zeros are required if the year value would otherwise have fewer than four digits; otherwise they are forbidden");
        }
        if (sign == -1) {
            date.year = this.parseIntYear(str, len);
        } else {
            date.year = this.parseIntYear(str, sign);
            this.getTimeZone(str, date, sign, len);
        }
        date.month = 1;
        date.day = 1;
        this.validateDateTime(date);
        this.saveUnnormalized(date);
        if (date.utc != 0 && date.utc != 90) {
            this.normalize(date);
        }
        date.position = 0;
        return date;
    }

    @Override
    protected String dateToString(AbstractDateTimeDV.DateTimeData date) {
        StringBuffer message = new StringBuffer(5);
        this.append(message, date.year, 4);
        this.append(message, (char)date.utc, 0);
        return message.toString();
    }

    @Override
    protected XMLGregorianCalendar getXMLGregorianCalendar(AbstractDateTimeDV.DateTimeData date) {
        return datatypeFactory.newXMLGregorianCalendar(date.unNormYear, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, date.hasTimeZone() ? date.timezoneHr * 60 + date.timezoneMin : Integer.MIN_VALUE);
    }
}

