/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.delivery.sax.ng.org.apache.xerces.jaxp.validation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.Comment;
import javax.xml.stream.events.DTD;
import javax.xml.stream.events.EndDocument;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.EntityDeclaration;
import javax.xml.stream.events.EntityReference;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.ProcessingInstruction;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stax.StAXResult;
import javax.xml.transform.stax.StAXSource;
import org.smooks.engine.delivery.sax.ng.org.apache.xerces.impl.XMLErrorReporter;
import org.smooks.engine.delivery.sax.ng.org.apache.xerces.impl.validation.EntityState;
import org.smooks.engine.delivery.sax.ng.org.apache.xerces.impl.validation.ValidationManager;
import org.smooks.engine.delivery.sax.ng.org.apache.xerces.impl.xs.XMLSchemaValidator;
import org.smooks.engine.delivery.sax.ng.org.apache.xerces.jaxp.validation.JAXPValidationMessageFormatter;
import org.smooks.engine.delivery.sax.ng.org.apache.xerces.jaxp.validation.StAXDocumentHandler;
import org.smooks.engine.delivery.sax.ng.org.apache.xerces.jaxp.validation.StAXEventResultBuilder;
import org.smooks.engine.delivery.sax.ng.org.apache.xerces.jaxp.validation.StAXStreamResultBuilder;
import org.smooks.engine.delivery.sax.ng.org.apache.xerces.jaxp.validation.Util;
import org.smooks.engine.delivery.sax.ng.org.apache.xerces.jaxp.validation.ValidatorHelper;
import org.smooks.engine.delivery.sax.ng.org.apache.xerces.jaxp.validation.XMLSchemaValidatorComponentManager;
import org.smooks.engine.delivery.sax.ng.org.apache.xerces.util.JAXPNamespaceContextWrapper;
import org.smooks.engine.delivery.sax.ng.org.apache.xerces.util.StAXLocationWrapper;
import org.smooks.engine.delivery.sax.ng.org.apache.xerces.util.SymbolTable;
import org.smooks.engine.delivery.sax.ng.org.apache.xerces.util.XMLAttributesImpl;
import org.smooks.engine.delivery.sax.ng.org.apache.xerces.util.XMLStringBuffer;
import org.smooks.engine.delivery.sax.ng.org.apache.xerces.util.XMLSymbols;
import org.smooks.engine.delivery.sax.ng.org.apache.xerces.xni.XMLString;
import org.smooks.engine.delivery.sax.ng.org.apache.xerces.xni.XNIException;
import org.smooks.engine.delivery.sax.ng.org.apache.xerces.xni.parser.XMLParseException;
import org.xml.sax.SAXException;

final class StAXValidatorHelper
implements ValidatorHelper,
EntityState {
    private static final String STRING_INTERNING = "javax.xml.stream.isInterning";
    private static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    private static final String SCHEMA_VALIDATOR = "http://apache.org/xml/properties/internal/validator/schema";
    private static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    private static final String VALIDATION_MANAGER = "http://apache.org/xml/properties/internal/validation-manager";
    private final XMLErrorReporter fErrorReporter;
    private final XMLSchemaValidator fSchemaValidator;
    private final SymbolTable fSymbolTable;
    private final ValidationManager fValidationManager;
    private final XMLSchemaValidatorComponentManager fComponentManager;
    private final JAXPNamespaceContextWrapper fNamespaceContext;
    private final StAXLocationWrapper fStAXLocationWrapper = new StAXLocationWrapper();
    private final XMLStreamReaderLocation fXMLStreamReaderLocation = new XMLStreamReaderLocation();
    private HashMap fEntities = null;
    private boolean fStringsInternalized = false;
    private StreamHelper fStreamHelper;
    private EventHelper fEventHelper;
    private StAXDocumentHandler fStAXValidatorHandler;
    private StAXStreamResultBuilder fStAXStreamResultBuilder;
    private StAXEventResultBuilder fStAXEventResultBuilder;
    private int fDepth = 0;
    private XMLEvent fCurrentEvent = null;
    final org.smooks.engine.delivery.sax.ng.org.apache.xerces.xni.QName fElementQName = new org.smooks.engine.delivery.sax.ng.org.apache.xerces.xni.QName();
    final org.smooks.engine.delivery.sax.ng.org.apache.xerces.xni.QName fAttributeQName = new org.smooks.engine.delivery.sax.ng.org.apache.xerces.xni.QName();
    final XMLAttributesImpl fAttributes = new XMLAttributesImpl();
    final ArrayList fDeclaredPrefixes = new ArrayList();
    final XMLString fTempString = new XMLString();
    final XMLStringBuffer fStringBuffer = new XMLStringBuffer();

    public StAXValidatorHelper(XMLSchemaValidatorComponentManager componentManager) {
        this.fComponentManager = componentManager;
        this.fErrorReporter = (XMLErrorReporter)this.fComponentManager.getProperty(ERROR_REPORTER);
        this.fSchemaValidator = (XMLSchemaValidator)this.fComponentManager.getProperty(SCHEMA_VALIDATOR);
        this.fSymbolTable = (SymbolTable)this.fComponentManager.getProperty(SYMBOL_TABLE);
        this.fValidationManager = (ValidationManager)this.fComponentManager.getProperty(VALIDATION_MANAGER);
        this.fNamespaceContext = new JAXPNamespaceContextWrapper(this.fSymbolTable);
        this.fNamespaceContext.setDeclaredPrefixes(this.fDeclaredPrefixes);
    }

    @Override
    public void validate(Source source, Result result) throws SAXException, IOException {
        if (result instanceof StAXResult || result == null) {
            StAXSource staxSource = (StAXSource)source;
            StAXResult staxResult = (StAXResult)result;
            try {
                XMLStreamReader streamReader = staxSource.getXMLStreamReader();
                if (streamReader != null) {
                    if (this.fStreamHelper == null) {
                        this.fStreamHelper = new StreamHelper();
                    }
                    this.fStreamHelper.validate(streamReader, staxResult);
                } else {
                    if (this.fEventHelper == null) {
                        this.fEventHelper = new EventHelper();
                    }
                    this.fEventHelper.validate(staxSource.getXMLEventReader(), staxResult);
                }
            }
            catch (XMLStreamException e) {
                throw new SAXException(e);
            }
            catch (XMLParseException e) {
                throw Util.toSAXParseException(e);
            }
            catch (XNIException e) {
                throw Util.toSAXException(e);
            }
            finally {
                this.fCurrentEvent = null;
                this.fStAXLocationWrapper.setLocation(null);
                this.fXMLStreamReaderLocation.setXMLStreamReader(null);
                if (this.fStAXValidatorHandler != null) {
                    this.fStAXValidatorHandler.setStAXResult(null);
                }
            }
            return;
        }
        throw new IllegalArgumentException(JAXPValidationMessageFormatter.formatMessage(this.fComponentManager.getLocale(), "SourceResultMismatch", new Object[]{source.getClass().getName(), result.getClass().getName()}));
    }

    @Override
    public boolean isEntityDeclared(String name) {
        if (this.fEntities != null) {
            return this.fEntities.containsKey(name);
        }
        return false;
    }

    @Override
    public boolean isEntityUnparsed(String name) {
        EntityDeclaration entityDecl;
        if (this.fEntities != null && (entityDecl = (EntityDeclaration)this.fEntities.get(name)) != null) {
            return entityDecl.getNotationName() != null;
        }
        return false;
    }

    final EntityDeclaration getEntityDeclaration(String name) {
        return this.fEntities != null ? (EntityDeclaration)this.fEntities.get(name) : null;
    }

    final XMLEvent getCurrentEvent() {
        return this.fCurrentEvent;
    }

    final void fillQName(org.smooks.engine.delivery.sax.ng.org.apache.xerces.xni.QName toFill, String uri, String localpart, String prefix) {
        if (!this.fStringsInternalized) {
            uri = uri != null && uri.length() > 0 ? this.fSymbolTable.addSymbol(uri) : null;
            localpart = localpart != null ? this.fSymbolTable.addSymbol(localpart) : XMLSymbols.EMPTY_STRING;
            prefix = prefix != null && prefix.length() > 0 ? this.fSymbolTable.addSymbol(prefix) : XMLSymbols.EMPTY_STRING;
        } else {
            if (uri != null && uri.length() == 0) {
                uri = null;
            }
            if (localpart == null) {
                localpart = XMLSymbols.EMPTY_STRING;
            }
            if (prefix == null) {
                prefix = XMLSymbols.EMPTY_STRING;
            }
        }
        String raw = localpart;
        if (prefix != XMLSymbols.EMPTY_STRING) {
            this.fStringBuffer.clear();
            this.fStringBuffer.append(prefix);
            this.fStringBuffer.append(':');
            this.fStringBuffer.append(localpart);
            raw = this.fSymbolTable.addSymbol(this.fStringBuffer.ch, this.fStringBuffer.offset, this.fStringBuffer.length);
        }
        toFill.setValues(prefix, localpart, raw, uri);
    }

    final void setup(Location location, StAXResult result, boolean stringsInternalized) {
        this.fDepth = 0;
        this.fComponentManager.reset();
        this.setupStAXResultHandler(result);
        this.fValidationManager.setEntityState(this);
        if (this.fEntities != null && !this.fEntities.isEmpty()) {
            this.fEntities.clear();
        }
        this.fStAXLocationWrapper.setLocation(location);
        this.fErrorReporter.setDocumentLocator(this.fStAXLocationWrapper);
        this.fStringsInternalized = stringsInternalized;
    }

    final void processEntityDeclarations(List entityDecls) {
        int size;
        int n = size = entityDecls != null ? entityDecls.size() : 0;
        if (size > 0) {
            if (this.fEntities == null) {
                this.fEntities = new HashMap();
            }
            for (int i = 0; i < size; ++i) {
                EntityDeclaration decl = (EntityDeclaration)entityDecls.get(i);
                this.fEntities.put(decl.getName(), decl);
            }
        }
    }

    private void setupStAXResultHandler(StAXResult result) {
        if (result == null) {
            this.fStAXValidatorHandler = null;
            this.fSchemaValidator.setDocumentHandler(null);
            return;
        }
        XMLStreamWriter writer = result.getXMLStreamWriter();
        if (writer != null) {
            if (this.fStAXStreamResultBuilder == null) {
                this.fStAXStreamResultBuilder = new StAXStreamResultBuilder(this.fNamespaceContext);
            }
            this.fStAXValidatorHandler = this.fStAXStreamResultBuilder;
            this.fStAXStreamResultBuilder.setStAXResult(result);
        } else {
            if (this.fStAXEventResultBuilder == null) {
                this.fStAXEventResultBuilder = new StAXEventResultBuilder(this, this.fNamespaceContext);
            }
            this.fStAXValidatorHandler = this.fStAXEventResultBuilder;
            this.fStAXEventResultBuilder.setStAXResult(result);
        }
        this.fSchemaValidator.setDocumentHandler(this.fStAXValidatorHandler);
    }

    static final class XMLStreamReaderLocation
    implements Location {
        private XMLStreamReader reader;

        @Override
        public int getCharacterOffset() {
            Location loc = this.getLocation();
            if (loc != null) {
                return loc.getCharacterOffset();
            }
            return -1;
        }

        @Override
        public int getColumnNumber() {
            Location loc = this.getLocation();
            if (loc != null) {
                return loc.getColumnNumber();
            }
            return -1;
        }

        @Override
        public int getLineNumber() {
            Location loc = this.getLocation();
            if (loc != null) {
                return loc.getLineNumber();
            }
            return -1;
        }

        @Override
        public String getPublicId() {
            Location loc = this.getLocation();
            if (loc != null) {
                return loc.getPublicId();
            }
            return null;
        }

        @Override
        public String getSystemId() {
            Location loc = this.getLocation();
            if (loc != null) {
                return loc.getSystemId();
            }
            return null;
        }

        public void setXMLStreamReader(XMLStreamReader reader) {
            this.reader = reader;
        }

        private Location getLocation() {
            return this.reader != null ? this.reader.getLocation() : null;
        }
    }

    final class EventHelper {
        private static final int CHUNK_SIZE = 1024;
        private static final int CHUNK_MASK = 1023;
        private final char[] fCharBuffer = new char[1024];

        EventHelper() {
        }

        /*
         * Enabled aggressive block sorting
         */
        final void validate(XMLEventReader reader, StAXResult result) throws SAXException, XMLStreamException {
            StAXValidatorHelper.this.fCurrentEvent = reader.peek();
            if (StAXValidatorHelper.this.fCurrentEvent != null) {
                int eventType = StAXValidatorHelper.this.fCurrentEvent.getEventType();
                if (eventType != 7 && eventType != 1) {
                    throw new SAXException(JAXPValidationMessageFormatter.formatMessage(StAXValidatorHelper.this.fComponentManager.getLocale(), "StAXIllegalInitialState", null));
                }
                StAXValidatorHelper.this.setup(null, result, false);
                StAXValidatorHelper.this.fSchemaValidator.startDocument(StAXValidatorHelper.this.fStAXLocationWrapper, null, StAXValidatorHelper.this.fNamespaceContext, null);
                block12: while (reader.hasNext()) {
                    StAXValidatorHelper.this.fCurrentEvent = reader.nextEvent();
                    eventType = StAXValidatorHelper.this.fCurrentEvent.getEventType();
                    switch (eventType) {
                        case 1: {
                            ++StAXValidatorHelper.this.fDepth;
                            StartElement start = StAXValidatorHelper.this.fCurrentEvent.asStartElement();
                            this.fillQName(StAXValidatorHelper.this.fElementQName, start.getName());
                            this.fillXMLAttributes(start);
                            this.fillDeclaredPrefixes(start);
                            StAXValidatorHelper.this.fNamespaceContext.setNamespaceContext(start.getNamespaceContext());
                            StAXValidatorHelper.this.fStAXLocationWrapper.setLocation(start.getLocation());
                            StAXValidatorHelper.this.fSchemaValidator.startElement(StAXValidatorHelper.this.fElementQName, StAXValidatorHelper.this.fAttributes, null);
                            break;
                        }
                        case 2: {
                            EndElement end = StAXValidatorHelper.this.fCurrentEvent.asEndElement();
                            this.fillQName(StAXValidatorHelper.this.fElementQName, end.getName());
                            this.fillDeclaredPrefixes(end);
                            StAXValidatorHelper.this.fStAXLocationWrapper.setLocation(end.getLocation());
                            StAXValidatorHelper.this.fSchemaValidator.endElement(StAXValidatorHelper.this.fElementQName, null);
                            if (--StAXValidatorHelper.this.fDepth > 0) break;
                            break block12;
                        }
                        case 4: 
                        case 6: {
                            Characters chars;
                            if (StAXValidatorHelper.this.fStAXValidatorHandler != null) {
                                chars = StAXValidatorHelper.this.fCurrentEvent.asCharacters();
                                StAXValidatorHelper.this.fStAXValidatorHandler.setIgnoringCharacters(true);
                                this.sendCharactersToValidator(chars.getData());
                                StAXValidatorHelper.this.fStAXValidatorHandler.setIgnoringCharacters(false);
                                StAXValidatorHelper.this.fStAXValidatorHandler.characters(chars);
                                break;
                            }
                            this.sendCharactersToValidator(StAXValidatorHelper.this.fCurrentEvent.asCharacters().getData());
                            break;
                        }
                        case 12: {
                            Characters chars;
                            if (StAXValidatorHelper.this.fStAXValidatorHandler != null) {
                                chars = StAXValidatorHelper.this.fCurrentEvent.asCharacters();
                                StAXValidatorHelper.this.fStAXValidatorHandler.setIgnoringCharacters(true);
                                StAXValidatorHelper.this.fSchemaValidator.startCDATA(null);
                                this.sendCharactersToValidator(StAXValidatorHelper.this.fCurrentEvent.asCharacters().getData());
                                StAXValidatorHelper.this.fSchemaValidator.endCDATA(null);
                                StAXValidatorHelper.this.fStAXValidatorHandler.setIgnoringCharacters(false);
                                StAXValidatorHelper.this.fStAXValidatorHandler.cdata(chars);
                                break;
                            }
                            StAXValidatorHelper.this.fSchemaValidator.startCDATA(null);
                            this.sendCharactersToValidator(StAXValidatorHelper.this.fCurrentEvent.asCharacters().getData());
                            StAXValidatorHelper.this.fSchemaValidator.endCDATA(null);
                            break;
                        }
                        case 7: {
                            ++StAXValidatorHelper.this.fDepth;
                            if (StAXValidatorHelper.this.fStAXValidatorHandler == null) break;
                            StAXValidatorHelper.this.fStAXValidatorHandler.startDocument((StartDocument)StAXValidatorHelper.this.fCurrentEvent);
                            break;
                        }
                        case 8: {
                            if (StAXValidatorHelper.this.fStAXValidatorHandler == null) break;
                            StAXValidatorHelper.this.fStAXValidatorHandler.endDocument((EndDocument)StAXValidatorHelper.this.fCurrentEvent);
                            break;
                        }
                        case 3: {
                            if (StAXValidatorHelper.this.fStAXValidatorHandler == null) break;
                            StAXValidatorHelper.this.fStAXValidatorHandler.processingInstruction((ProcessingInstruction)StAXValidatorHelper.this.fCurrentEvent);
                            break;
                        }
                        case 5: {
                            if (StAXValidatorHelper.this.fStAXValidatorHandler == null) break;
                            StAXValidatorHelper.this.fStAXValidatorHandler.comment((Comment)StAXValidatorHelper.this.fCurrentEvent);
                            break;
                        }
                        case 9: {
                            if (StAXValidatorHelper.this.fStAXValidatorHandler == null) break;
                            StAXValidatorHelper.this.fStAXValidatorHandler.entityReference((EntityReference)StAXValidatorHelper.this.fCurrentEvent);
                            break;
                        }
                        case 11: {
                            DTD dtd = (DTD)StAXValidatorHelper.this.fCurrentEvent;
                            StAXValidatorHelper.this.processEntityDeclarations(dtd.getEntities());
                            if (StAXValidatorHelper.this.fStAXValidatorHandler == null) break;
                            StAXValidatorHelper.this.fStAXValidatorHandler.doctypeDecl(dtd);
                        }
                    }
                }
                StAXValidatorHelper.this.fSchemaValidator.endDocument(null);
            }
        }

        private void fillQName(org.smooks.engine.delivery.sax.ng.org.apache.xerces.xni.QName toFill, QName toCopy) {
            StAXValidatorHelper.this.fillQName(toFill, toCopy.getNamespaceURI(), toCopy.getLocalPart(), toCopy.getPrefix());
        }

        private void fillXMLAttributes(StartElement event) {
            StAXValidatorHelper.this.fAttributes.removeAllAttributes();
            Iterator attrs = event.getAttributes();
            while (attrs.hasNext()) {
                Attribute attr = (Attribute)attrs.next();
                this.fillQName(StAXValidatorHelper.this.fAttributeQName, attr.getName());
                String type = attr.getDTDType();
                int idx = StAXValidatorHelper.this.fAttributes.getLength();
                StAXValidatorHelper.this.fAttributes.addAttributeNS(StAXValidatorHelper.this.fAttributeQName, type != null ? type : XMLSymbols.fCDATASymbol, attr.getValue());
                StAXValidatorHelper.this.fAttributes.setSpecified(idx, attr.isSpecified());
            }
        }

        private void fillDeclaredPrefixes(StartElement event) {
            this.fillDeclaredPrefixes(event.getNamespaces());
        }

        private void fillDeclaredPrefixes(EndElement event) {
            this.fillDeclaredPrefixes(event.getNamespaces());
        }

        private void fillDeclaredPrefixes(Iterator namespaces) {
            StAXValidatorHelper.this.fDeclaredPrefixes.clear();
            while (namespaces.hasNext()) {
                Namespace ns = (Namespace)namespaces.next();
                String prefix = ns.getPrefix();
                StAXValidatorHelper.this.fDeclaredPrefixes.add(prefix != null ? prefix : "");
            }
        }

        private void sendCharactersToValidator(String str) {
            if (str != null) {
                int length = str.length();
                int remainder = length & 0x3FF;
                if (remainder > 0) {
                    str.getChars(0, remainder, this.fCharBuffer, 0);
                    StAXValidatorHelper.this.fTempString.setValues(this.fCharBuffer, 0, remainder);
                    StAXValidatorHelper.this.fSchemaValidator.characters(StAXValidatorHelper.this.fTempString, null);
                }
                int i = remainder;
                while (i < length) {
                    str.getChars(i, i += 1024, this.fCharBuffer, 0);
                    StAXValidatorHelper.this.fTempString.setValues(this.fCharBuffer, 0, 1024);
                    StAXValidatorHelper.this.fSchemaValidator.characters(StAXValidatorHelper.this.fTempString, null);
                }
            }
        }
    }

    final class StreamHelper {
        StreamHelper() {
        }

        final void validate(XMLStreamReader reader, StAXResult result) throws SAXException, XMLStreamException {
            if (reader.hasNext()) {
                int eventType = reader.getEventType();
                if (eventType != 7 && eventType != 1) {
                    throw new SAXException(JAXPValidationMessageFormatter.formatMessage(StAXValidatorHelper.this.fComponentManager.getLocale(), "StAXIllegalInitialState", null));
                }
                StAXValidatorHelper.this.fXMLStreamReaderLocation.setXMLStreamReader(reader);
                Object isInterning = Boolean.FALSE;
                try {
                    isInterning = reader.getProperty(StAXValidatorHelper.STRING_INTERNING);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                StAXValidatorHelper.this.setup(StAXValidatorHelper.this.fXMLStreamReaderLocation, result, Boolean.TRUE.equals(isInterning));
                StAXValidatorHelper.this.fSchemaValidator.startDocument(StAXValidatorHelper.this.fStAXLocationWrapper, null, StAXValidatorHelper.this.fNamespaceContext, null);
                do {
                    switch (eventType) {
                        case 1: {
                            ++StAXValidatorHelper.this.fDepth;
                            StAXValidatorHelper.this.fillQName(StAXValidatorHelper.this.fElementQName, reader.getNamespaceURI(), reader.getLocalName(), reader.getPrefix());
                            this.fillXMLAttributes(reader);
                            this.fillDeclaredPrefixes(reader);
                            StAXValidatorHelper.this.fNamespaceContext.setNamespaceContext(reader.getNamespaceContext());
                            StAXValidatorHelper.this.fSchemaValidator.startElement(StAXValidatorHelper.this.fElementQName, StAXValidatorHelper.this.fAttributes, null);
                            break;
                        }
                        case 2: {
                            StAXValidatorHelper.this.fillQName(StAXValidatorHelper.this.fElementQName, reader.getNamespaceURI(), reader.getLocalName(), reader.getPrefix());
                            this.fillDeclaredPrefixes(reader);
                            StAXValidatorHelper.this.fNamespaceContext.setNamespaceContext(reader.getNamespaceContext());
                            StAXValidatorHelper.this.fSchemaValidator.endElement(StAXValidatorHelper.this.fElementQName, null);
                            --StAXValidatorHelper.this.fDepth;
                            break;
                        }
                        case 4: 
                        case 6: {
                            StAXValidatorHelper.this.fTempString.setValues(reader.getTextCharacters(), reader.getTextStart(), reader.getTextLength());
                            StAXValidatorHelper.this.fSchemaValidator.characters(StAXValidatorHelper.this.fTempString, null);
                            break;
                        }
                        case 12: {
                            StAXValidatorHelper.this.fSchemaValidator.startCDATA(null);
                            StAXValidatorHelper.this.fTempString.setValues(reader.getTextCharacters(), reader.getTextStart(), reader.getTextLength());
                            StAXValidatorHelper.this.fSchemaValidator.characters(StAXValidatorHelper.this.fTempString, null);
                            StAXValidatorHelper.this.fSchemaValidator.endCDATA(null);
                            break;
                        }
                        case 7: {
                            ++StAXValidatorHelper.this.fDepth;
                            if (StAXValidatorHelper.this.fStAXValidatorHandler == null) break;
                            StAXValidatorHelper.this.fStAXValidatorHandler.startDocument(reader);
                            break;
                        }
                        case 3: {
                            if (StAXValidatorHelper.this.fStAXValidatorHandler == null) break;
                            StAXValidatorHelper.this.fStAXValidatorHandler.processingInstruction(reader);
                            break;
                        }
                        case 5: {
                            if (StAXValidatorHelper.this.fStAXValidatorHandler == null) break;
                            StAXValidatorHelper.this.fStAXValidatorHandler.comment(reader);
                            break;
                        }
                        case 9: {
                            if (StAXValidatorHelper.this.fStAXValidatorHandler == null) break;
                            StAXValidatorHelper.this.fStAXValidatorHandler.entityReference(reader);
                            break;
                        }
                        case 11: {
                            StAXValidatorHelper.this.processEntityDeclarations((List)reader.getProperty("javax.xml.stream.entities"));
                        }
                    }
                    eventType = reader.next();
                } while (reader.hasNext() && StAXValidatorHelper.this.fDepth > 0);
                StAXValidatorHelper.this.fSchemaValidator.endDocument(null);
                if (eventType == 8 && StAXValidatorHelper.this.fStAXValidatorHandler != null) {
                    StAXValidatorHelper.this.fStAXValidatorHandler.endDocument(reader);
                }
            }
        }

        private void fillXMLAttributes(XMLStreamReader reader) {
            StAXValidatorHelper.this.fAttributes.removeAllAttributes();
            int len = reader.getAttributeCount();
            for (int i = 0; i < len; ++i) {
                StAXValidatorHelper.this.fillQName(StAXValidatorHelper.this.fAttributeQName, reader.getAttributeNamespace(i), reader.getAttributeLocalName(i), reader.getAttributePrefix(i));
                String type = reader.getAttributeType(i);
                StAXValidatorHelper.this.fAttributes.addAttributeNS(StAXValidatorHelper.this.fAttributeQName, type != null ? type : XMLSymbols.fCDATASymbol, reader.getAttributeValue(i));
                StAXValidatorHelper.this.fAttributes.setSpecified(i, reader.isAttributeSpecified(i));
            }
        }

        private void fillDeclaredPrefixes(XMLStreamReader reader) {
            StAXValidatorHelper.this.fDeclaredPrefixes.clear();
            int len = reader.getNamespaceCount();
            for (int i = 0; i < len; ++i) {
                String prefix = reader.getNamespacePrefix(i);
                StAXValidatorHelper.this.fDeclaredPrefixes.add(prefix != null ? prefix : "");
            }
        }
    }
}

