/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.injector;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.inject.Inject;
import javax.inject.Named;
import org.smooks.api.SmooksConfigException;
import org.smooks.engine.injector.AbstractInjector;
import org.smooks.engine.injector.Scope;
import org.smooks.support.ClassUtils;

public class FieldInjector
extends AbstractInjector<Field> {
    private final Object instance;
    private final Scope scope;

    public FieldInjector(Object instance, Scope scope) {
        this.instance = instance;
        this.scope = scope;
    }

    @Override
    public void inject() {
        this.inject(this.instance.getClass(), this.instance, this.scope);
    }

    private void inject(Class<?> instanceClass, Object instance, Scope scope) {
        Field[] fields = instanceClass.getDeclaredFields();
        Class<?> superClass = instanceClass.getSuperclass();
        if (superClass != null) {
            this.inject(superClass, instance, scope);
        }
        for (Field field : fields) {
            Inject injectAnnotation = field.getAnnotation(Inject.class);
            if (injectAnnotation == null) continue;
            this.inject(field.getAnnotation(Named.class), field, instance, scope);
        }
    }

    @Override
    protected Class<?> getType(Field field) {
        return field.getType();
    }

    @Override
    protected Type getActualType(Field field) {
        return ((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
    }

    @Override
    protected String getName(Named namedAnnotation, Field field) {
        if (namedAnnotation == null) {
            return field.getName();
        }
        return namedAnnotation.value();
    }

    @Override
    protected Object getDefaultParamValue(Object instance, Field field) {
        try {
            return ClassUtils.getField(field, instance);
        }
        catch (IllegalAccessException e) {
            throw new SmooksConfigException(e);
        }
    }

    @Override
    protected void doSetMember(Member member, Object instance, Object value, String name) throws IllegalAccessException {
        ClassUtils.setField((Field)member, instance, value);
    }
}

