/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.injector;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.inject.Inject;
import javax.inject.Named;
import org.smooks.api.SmooksConfigException;
import org.smooks.engine.injector.AbstractInjector;
import org.smooks.engine.injector.Scope;
import org.smooks.support.ClassUtils;

public class MethodInjector
extends AbstractInjector<Method> {
    private final Object instance;
    private final Scope scope;

    public MethodInjector(Object instance, Scope scope) {
        this.instance = instance;
        this.scope = scope;
    }

    @Override
    public void inject() {
        Method[] methods;
        for (Method method : methods = this.instance.getClass().getMethods()) {
            Inject injectAnnotation = method.getAnnotation(Inject.class);
            if (injectAnnotation == null) continue;
            Class<?>[] params = method.getParameterTypes();
            if (params.length == 1) {
                this.inject(method.getParameters()[0].getAnnotation(Named.class), method, this.instance, this.scope);
                continue;
            }
            throw new SmooksConfigException("Method '" + ClassUtils.getLongMemberName(method) + "' defines a @Inject, yet it specifies more than a single paramater.");
        }
    }

    @Override
    protected Class<?> getType(Method method) {
        return method.getParameterTypes()[0];
    }

    @Override
    protected Type getActualType(Method method) {
        return ((ParameterizedType)method.getGenericParameterTypes()[0]).getActualTypeArguments()[0];
    }

    @Override
    protected String getName(Named namedAnnotation, Method method) {
        String name;
        if (namedAnnotation == null) {
            name = this.getPropertyName(method);
            if (name == null) {
                throw new SmooksConfigException("Unable to determine the property name associated with '" + ClassUtils.getLongMemberName(method) + "'. Setter methods that specify the @Inject annotation must either follow the Javabean naming convention ('setX' for property 'x'), or specify the property name via the 'name' parameter on the @Inject annotation.");
            }
        } else {
            name = namedAnnotation.value();
        }
        return name;
    }

    @Override
    protected Object getDefaultParamValue(Object instance, Method member) {
        return null;
    }

    @Override
    protected void doSetMember(Member member, Object instance, Object value, String name) throws InvocationTargetException, IllegalAccessException {
        ((Method)member).invoke(instance, value);
    }

    private String getPropertyName(Method method) {
        if (!method.getName().startsWith("set")) {
            return null;
        }
        StringBuffer methodName = new StringBuffer(method.getName());
        if (methodName.length() < 4) {
            return null;
        }
        methodName.delete(0, 3);
        methodName.setCharAt(0, Character.toLowerCase(methodName.charAt(0)));
        return methodName.toString();
    }
}

