/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.injector;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.smooks.api.Registry;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.api.resource.visitor.sax.ng.SaxNgVisitor;
import org.smooks.engine.lookup.GlobalParamsLookup;
import org.smooks.io.DomSerializer;

public class Scope
implements Map<Object, Object> {
    private final Map<Object, Object> scope = new HashMap<Object, Object>();

    public Scope(Registry registry, ResourceConfig resourceConfig, Object instance) {
        this(registry);
        this.scope.put(ResourceConfig.class, resourceConfig);
        for (String parameterName : resourceConfig.getParameters().keySet()) {
            this.scope.put(parameterName, resourceConfig.getParameterValue(parameterName));
        }
        boolean entitiesRewrite = Boolean.parseBoolean(resourceConfig.getParameterValue("entities.rewrite", String.class, "true"));
        if (instance instanceof SaxNgVisitor) {
            boolean closeEmptyElements = Boolean.parseBoolean(resourceConfig.getParameterValue("close.empty.elements", String.class, "false"));
            this.scope.put(DomSerializer.class, new DomSerializer(closeEmptyElements, entitiesRewrite));
        }
    }

    public Scope(Registry registry) {
        this.scope.put(Registry.class, registry);
        this.scope.putAll(registry.lookup(registryEntries -> registryEntries));
        ResourceConfig globalParams = registry.lookup(new GlobalParamsLookup(registry));
        for (String parameterName : globalParams.getParameters().keySet()) {
            this.scope.put(parameterName, globalParams.getParameterValue(parameterName));
        }
    }

    public Registry getRegistry() {
        return (Registry)this.scope.get(Registry.class);
    }

    @Override
    public int size() {
        return this.scope.size();
    }

    @Override
    public boolean isEmpty() {
        return this.scope.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.scope.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.scope.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        return this.scope.get(key);
    }

    @Override
    public Object put(Object key, Object value) {
        return this.scope.put(key, value);
    }

    @Override
    public Object remove(Object key) {
        return this.scope.remove(key);
    }

    @Override
    public void putAll(Map<?, ?> m) {
        this.scope.putAll(m);
    }

    @Override
    public void clear() {
        this.scope.clear();
    }

    @Override
    public Set<Object> keySet() {
        return this.scope.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.scope.values();
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        return this.scope.entrySet();
    }
}

