/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.memento;

import org.smooks.api.TypedKey;
import org.smooks.api.delivery.fragment.Fragment;
import org.smooks.api.memento.Memento;

public class TextAccumulatorMemento
implements Memento {
    private static final TypedKey<String> ANCHOR_TYPED_KEY = TypedKey.of();
    protected final Fragment<?> fragment;
    protected final StringBuilder stringBuilder = new StringBuilder();
    protected String anchor;

    public TextAccumulatorMemento(Fragment<?> fragment) {
        this.fragment = fragment;
    }

    @Override
    public Memento copy() {
        TextAccumulatorMemento textAccumulatorMemento = new TextAccumulatorMemento(this.fragment);
        textAccumulatorMemento.accumulateText(this.getText());
        return textAccumulatorMemento;
    }

    @Override
    public void restore(Memento memento) {
        this.stringBuilder.append(((TextAccumulatorMemento)memento).getText());
    }

    @Override
    public Fragment<?> getFragment() {
        return this.fragment;
    }

    @Override
    public String getAnchor() {
        if (this.anchor == null) {
            this.anchor = ANCHOR_TYPED_KEY.getName() + "@" + this.fragment.getId();
        }
        return this.anchor;
    }

    public TextAccumulatorMemento accumulateText(String text) {
        this.stringBuilder.append(text);
        return this;
    }

    public String getText() {
        return this.stringBuilder.toString();
    }
}

