/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.report;

import java.io.File;
import java.io.Writer;
import org.smooks.api.SmooksConfigException;
import org.smooks.api.delivery.event.ContentDeliveryConfigExecutionEvent;
import org.smooks.api.delivery.event.ExecutionEvent;
import org.smooks.assertion.AssertArgument;
import org.smooks.engine.delivery.event.VisitExecutionEvent;

public class ReportConfiguration {
    public static final File TEMP_DIR = new File(System.getProperty("java.io.tmpdir"));
    private Writer outputWriter;
    private boolean escapeXMLChars;
    private boolean showDefaultAppliedResources;
    private Class<? extends ExecutionEvent>[] filterEvents;
    private boolean autoCloseWriter = true;
    private File tempOutDir = TEMP_DIR;

    public ReportConfiguration(Writer outputWriter) {
        AssertArgument.isNotNull(outputWriter, "outputWriter");
        this.outputWriter = outputWriter;
        this.filterEvents = new Class[]{ContentDeliveryConfigExecutionEvent.class, VisitExecutionEvent.class};
    }

    public void setOutputWriter(Writer outputWriter) {
        this.outputWriter = outputWriter;
    }

    public Writer getOutputWriter() {
        return this.outputWriter;
    }

    public boolean escapeXMLChars() {
        return this.escapeXMLChars;
    }

    public void setEscapeXMLChars(boolean escapeXMLChars) {
        this.escapeXMLChars = escapeXMLChars;
    }

    public boolean showDefaultAppliedResources() {
        return this.showDefaultAppliedResources;
    }

    public void setShowDefaultAppliedResources(boolean showDefaultAppliedResources) {
        this.showDefaultAppliedResources = showDefaultAppliedResources;
    }

    public void setFilterEvents(Class<? extends ExecutionEvent> ... filterEvents) {
        this.filterEvents = filterEvents;
    }

    public Class<? extends ExecutionEvent>[] getFilterEvents() {
        return this.filterEvents;
    }

    public boolean autoCloseWriter() {
        return this.autoCloseWriter;
    }

    public void setAutoCloseWriter(boolean autoCloseWriter) {
        this.autoCloseWriter = autoCloseWriter;
    }

    public File getTempOutDir() {
        if (this.tempOutDir == null) {
            throw new SmooksConfigException("Temp OutDir not set.");
        }
        return this.tempOutDir;
    }

    public void setTempOutDir(File tempOutDir) {
        this.tempOutDir = tempOutDir;
    }
}

