/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.resource.config;

import org.smooks.api.profile.ProfileSet;
import org.smooks.api.resource.config.ProfileTargetingExpression;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.api.resource.config.ResourceConfigSortComparator;

public class DefaultResourceConfigSortComparator
implements ResourceConfigSortComparator {
    private final ProfileSet profileSet;

    public DefaultResourceConfigSortComparator(ProfileSet profileSet) {
        this.profileSet = profileSet;
    }

    @Override
    public int compare(ResourceConfig configObj1, ResourceConfig configObj2) {
        double config2Specificity;
        if (configObj1 == configObj2) {
            return 0;
        }
        double config1Specificity = this.getSpecificity(configObj1);
        if (config1Specificity > (config2Specificity = this.getSpecificity(configObj2))) {
            return -1;
        }
        if (config1Specificity < config2Specificity) {
            return 1;
        }
        return 0;
    }

    protected double getSpecificity(ResourceConfig resourceConfig) {
        double specificity = 0.0;
        ProfileTargetingExpression[] profileTargetingExpressions = resourceConfig.getProfileTargetingExpressions();
        for (int i = 0; i < profileTargetingExpressions.length; ++i) {
            specificity += profileTargetingExpressions[i].getSpecificity(this.profileSet);
        }
        if (resourceConfig.getSelectorPath().getSelector().equals("*")) {
            specificity += 5.0;
        } else {
            specificity += 100.0;
            if (resourceConfig.getSelectorPath().size() > 1) {
                int contextSpecificity = resourceConfig.getSelectorPath().size();
                specificity += (double)(10 * (contextSpecificity - 1));
            }
        }
        return specificity;
    }
}

