/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.resource.config;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.smooks.Smooks;
import org.smooks.api.Registry;
import org.smooks.api.delivery.ContentDeliveryConfig;
import org.smooks.api.resource.config.Parameter;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.api.resource.config.ResourceConfigSeq;
import org.smooks.assertion.AssertArgument;
import org.smooks.engine.lookup.ResourceConfigSeqsLookup;
import org.smooks.engine.resource.config.DefaultParameter;
import org.smooks.engine.resource.config.DefaultResourceConfig;

public abstract class ParameterAccessor {
    public static final String GLOBAL_PARAMETERS = "global-parameters";

    public static <T> T getParameterValue(String name, Class<T> valueClass, ContentDeliveryConfig config) {
        Parameter<T> param = ParameterAccessor.getParameter(name, valueClass, config);
        if (param != null) {
            return param.getValue();
        }
        return null;
    }

    public static <T> T getParameterValue(String name, Class<T> valueClass, T defaultVal, ContentDeliveryConfig config) {
        Parameter<T> param = ParameterAccessor.getParameter(name, valueClass, config);
        if (param != null) {
            return param.getValue();
        }
        return defaultVal;
    }

    public static <T> Parameter<T> getParameter(String name, Class<T> valueType, ContentDeliveryConfig config) {
        AssertArgument.isNotNullAndNotEmpty(name, "name");
        AssertArgument.isNotNull(config, "config");
        return ParameterAccessor.getParameter(name, valueType, config.getResourceConfigs());
    }

    public static <T> Parameter<T> getParameter(String name, Class<T> valueType, Map<String, List<ResourceConfig>> resourceConfigsBySelector) {
        String systemValue;
        AssertArgument.isNotNullAndNotEmpty(name, "name");
        AssertArgument.isNotNull(resourceConfigsBySelector, "resourceConfigsBySelector");
        List<ResourceConfig> resourceConfigs = resourceConfigsBySelector.get(GLOBAL_PARAMETERS);
        if (resourceConfigs != null) {
            for (ResourceConfig resourceConfig : resourceConfigs) {
                Parameter<T> param = resourceConfig.getParameter(name, valueType);
                if (param == null) continue;
                return param;
            }
        }
        if ((systemValue = System.getProperty(name)) != null) {
            return new DefaultParameter<String>(name, systemValue);
        }
        return null;
    }

    public static <T> T getParameterValue(String name, Class<T> valueType, T defaultVal, Map<String, List<ResourceConfig>> config) {
        Parameter<T> param = ParameterAccessor.getParameter(name, valueType, config);
        if (param != null) {
            return param.getValue();
        }
        return defaultVal;
    }

    public static <T> T getParameterValue(String name, Class<T> valueType, Map<String, List<ResourceConfig>> resourceConfigsBySelector) {
        Parameter<T> parameter = ParameterAccessor.getParameter(name, valueType, resourceConfigsBySelector);
        if (parameter != null) {
            return parameter.getValue();
        }
        return null;
    }

    public static void setParameter(String name, Object value, Smooks smooks) {
        DefaultResourceConfig resourceConfig = new DefaultResourceConfig(GLOBAL_PARAMETERS, new Properties());
        resourceConfig.setParameter(name, value);
        smooks.getApplicationContext().getRegistry().registerResourceConfig(resourceConfig);
    }

    public static void removeParameter(String name, Smooks smooks) {
        Registry registry = smooks.getApplicationContext().getRegistry();
        for (ResourceConfigSeq list : registry.lookup(new ResourceConfigSeqsLookup())) {
            for (int i = 0; i < list.size(); ++i) {
                ResourceConfig nextResourceConfig = list.get(i);
                if (!GLOBAL_PARAMETERS.equals(nextResourceConfig.getSelectorPath().getSelector())) continue;
                nextResourceConfig.removeParameter(name);
            }
        }
    }
}

