/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.resource.config;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.StringTokenizer;
import java.util.Vector;
import org.smooks.api.resource.config.ParameterDecodeException;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.engine.resource.config.ParameterDecoder;

public class TokenizedStringParameterDecoder
extends ParameterDecoder<String> {
    private Class returnType;
    private String delims;
    private boolean returnDelims;
    private boolean trimTokens;

    public void setConfiguration(ResourceConfig resourceConfig) {
        this.delims = resourceConfig.getParameterValue("delims", String.class, ",");
        this.returnDelims = resourceConfig.getParameterValue("returnDelims", Boolean.class, false);
        this.trimTokens = resourceConfig.getParameterValue("trimTokens", Boolean.class, true);
        String paramType = resourceConfig.getParameterValue("param-type:", String.class, "string-list");
        if (paramType.equals("string-list")) {
            this.returnType = Vector.class;
        } else if (paramType.equals("string-hashset")) {
            this.returnType = LinkedHashSet.class;
        } else {
            throw new ParameterDecodeException("Unsupported decoded return type [" + paramType + "]");
        }
    }

    @Override
    public Object decodeValue(String value) throws ParameterDecodeException {
        Collection returnVal;
        try {
            returnVal = (Collection)this.returnType.newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to construct Collection instance.", e);
        }
        StringTokenizer tokenizer = new StringTokenizer(value, this.delims, this.returnDelims);
        while (tokenizer.hasMoreTokens()) {
            if (this.trimTokens) {
                returnVal.add(tokenizer.nextToken().trim());
                continue;
            }
            returnVal.add(tokenizer.nextToken());
        }
        return returnVal;
    }
}

