/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.resource.config.loader.xml.extension;

import java.util.Optional;
import javax.inject.Inject;
import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksException;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.api.resource.config.ResourceConfigFactory;
import org.smooks.api.resource.visitor.dom.DOMElementVisitor;
import org.smooks.engine.resource.config.DefaultResourceConfigFactory;
import org.smooks.engine.resource.config.loader.xml.extension.ExtensionContext;
import org.smooks.support.DomUtils;
import org.w3c.dom.Element;

public class NewResourceConfig
implements DOMElementVisitor {
    public static final String PARAMETER_TARGET_PROFILE = "targetProfile";
    @Inject
    private Optional<String> resource;
    @Inject
    private ResourceConfigFactory resourceConfigFactory = new DefaultResourceConfigFactory();
    @Inject
    private Boolean isTemplate = false;

    @Override
    public void visitBefore(Element element, ExecutionContext executionContext) throws SmooksException {
        ExtensionContext extensionContext = executionContext.get(ExtensionContext.EXTENSION_CONTEXT_TYPED_KEY);
        String targetProfile = DomUtils.getAttributeValue(element, PARAMETER_TARGET_PROFILE);
        if (targetProfile == null) {
            targetProfile = extensionContext.getDefaultProfile();
        }
        ResourceConfig resourceConfig = this.resourceConfigFactory.create(targetProfile, element);
        resourceConfig.setResource(this.resource.orElse(null));
        resourceConfig.getSelectorPath().setConditionEvaluator(extensionContext.getDefaultConditionEvaluator());
        if (this.isTemplate.booleanValue()) {
            extensionContext.addResourceTemplate(resourceConfig);
        } else {
            extensionContext.addResourceConfig(resourceConfig);
        }
    }

    @Override
    public void visitAfter(Element element, ExecutionContext executionContext) throws SmooksException {
        executionContext.get(ExtensionContext.EXTENSION_CONTEXT_TYPED_KEY).getResourceStack().pop();
    }
}

