/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.xml;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.smooks.api.ExecutionContext;
import org.smooks.api.TypedKey;
import org.smooks.api.resource.config.ResourceConfig;

public abstract class DocType {
    private static final TypedKey<DocumentTypeData> DOCTYPE_KEY = TypedKey.of();

    public static void setDocType(String name, String publicId, String systemId, String xmlns, ExecutionContext executionContext) {
        executionContext.put(DOCTYPE_KEY, new DocumentTypeData(name, publicId, systemId, xmlns));
    }

    public static DocumentTypeData getDocType(ExecutionContext executionContext) {
        List<ResourceConfig> docTypeUDs = executionContext.getContentDeliveryRuntime().getContentDeliveryConfig().getResourceConfigs("doctype");
        ResourceConfig docTypeResourceConfig = null;
        if (docTypeUDs != null && docTypeUDs.size() > 0) {
            docTypeResourceConfig = docTypeUDs.get(0);
        }
        if (docTypeResourceConfig != null && docTypeResourceConfig.getParameterValue("override", Boolean.class, true).booleanValue()) {
            String name = docTypeResourceConfig.getParameterValue("name", String.class, "!!DOCTYPE name undefined - fix smooks-resource!!");
            String publicId = docTypeResourceConfig.getParameterValue("publicId", String.class, "!!DOCTYPE publicId undefined - fix smooks-resource!!");
            String systemId = docTypeResourceConfig.getParameterValue("systemId", String.class, "!!DOCTYPE systemId undefined - fix smooks-resource!!");
            String xmlns = docTypeResourceConfig.getParameterValue("xmlns", String.class);
            boolean omit = docTypeResourceConfig.getParameterValue("omit", Boolean.class, false);
            return new DocumentTypeData(name, publicId, systemId, xmlns, omit);
        }
        return executionContext.get(DOCTYPE_KEY);
    }

    public static void serializeDoctype(DocumentTypeData docTypeData, Writer writer) throws IOException {
        if (docTypeData != null && !docTypeData.omit) {
            writer.write("<?xml version='1.0'?>\n");
            writer.write("<!DOCTYPE ");
            writer.write(docTypeData.getName());
            writer.write(32);
            if (docTypeData.getPublicId() != null) {
                writer.write("PUBLIC \"");
                writer.write(docTypeData.getPublicId());
                writer.write("\" ");
            }
            if (docTypeData.getSystemId() != null) {
                writer.write(34);
                writer.write(docTypeData.getSystemId());
                writer.write(34);
            }
            writer.write(62);
            writer.write(10);
        }
    }

    public static class DocumentTypeData {
        private final String name;
        private final String publicId;
        private final String systemId;
        private String xmlns;
        private boolean omit;

        public DocumentTypeData(String name, String publicId, String systemId, String xmlns) {
            this.name = name;
            this.publicId = publicId;
            this.systemId = systemId;
            this.xmlns = xmlns;
        }

        public DocumentTypeData(String name, String publicId, String systemId, String xmlns, boolean omit) {
            this(name, publicId, systemId, xmlns);
            this.omit = omit;
        }

        public String getName() {
            return this.name;
        }

        public String getPublicId() {
            return this.publicId;
        }

        public String getSystemId() {
            return this.systemId;
        }

        public String getXmlns() {
            return this.xmlns;
        }

        public void setXmlns(String xmlns) {
            this.xmlns = xmlns;
        }
    }
}

