/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.support;

import freemarker.ext.dom.NodeModel;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.smooks.api.ExecutionContext;
import org.smooks.api.TypedKey;
import org.smooks.engine.resource.visitor.dom.DOMModel;
import org.w3c.dom.Element;

public abstract class FreeMarkerUtils {
    private static final TypedKey<Map<String, ElementToNodeModel>> ELEMENT_TO_NODE_MODEL_TYPED_KEY = TypedKey.of();

    public static Map<String, Object> getMergedModel(ExecutionContext executionContext) {
        Map<String, Object> beans;
        Map<String, Object> model = beans = executionContext.getBeanContext().getBeanMap();
        DOMModel domModel = DOMModel.getModel(executionContext);
        if (!domModel.getModels().isEmpty()) {
            Map<String, ElementToNodeModel> elementToNodeModelMap = FreeMarkerUtils.getElementToNodeModelMap(executionContext);
            model = new HashMap<String, Object>(beans);
            Set<Map.Entry<String, Element>> models = domModel.getModels().entrySet();
            for (Map.Entry<String, Element> entry : models) {
                NodeModel nodeModel = FreeMarkerUtils.getNodeModel(entry.getKey(), entry.getValue(), elementToNodeModelMap);
                model.put(entry.getKey(), nodeModel);
            }
        }
        return model;
    }

    private static NodeModel getNodeModel(String key, Element element, Map<String, ElementToNodeModel> elementToNodeModelMap) {
        ElementToNodeModel elementToNodeModel = elementToNodeModelMap.get(key);
        if (elementToNodeModel == null) {
            elementToNodeModel = new ElementToNodeModel();
            elementToNodeModelMap.put(key, elementToNodeModel);
            elementToNodeModel.element = element;
            elementToNodeModel.nodeModel = NodeModel.wrap(element);
        } else if (elementToNodeModel.element != element) {
            elementToNodeModel.element = element;
            elementToNodeModel.nodeModel = NodeModel.wrap(element);
        }
        return elementToNodeModel.nodeModel;
    }

    private static Map<String, ElementToNodeModel> getElementToNodeModelMap(ExecutionContext executionContext) {
        Map<String, ElementToNodeModel> map = executionContext.get(ELEMENT_TO_NODE_MODEL_TYPED_KEY);
        if (map == null) {
            map = new HashMap<String, ElementToNodeModel>();
            executionContext.put(ELEMENT_TO_NODE_MODEL_TYPED_KEY, map);
        }
        return map;
    }

    private static class ElementToNodeModel {
        private Element element;
        private NodeModel nodeModel;

        private ElementToNodeModel() {
        }
    }
}

