/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.smpp;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.component.smpp.SmppCommand;
import org.apache.camel.component.smpp.SmppCommandType;
import org.apache.camel.component.smpp.SmppConfiguration;
import org.apache.camel.component.smpp.SmppMessage;
import org.apache.camel.component.smpp.SmppMessageType;
import org.apache.camel.component.smpp.SmppUtils;
import org.jsmpp.bean.AlertNotification;
import org.jsmpp.bean.DataSm;
import org.jsmpp.bean.DeliverSm;
import org.jsmpp.bean.DeliveryReceipt;
import org.jsmpp.bean.OptionalParameter;
import org.jsmpp.session.SMPPSession;
import org.jsmpp.util.DefaultDecomposer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmppBinding {
    private static final Logger LOG = LoggerFactory.getLogger(SmppBinding.class);
    private SmppConfiguration configuration;

    public SmppBinding() {
        this.configuration = new SmppConfiguration();
    }

    public SmppBinding(SmppConfiguration configuration) {
        this.configuration = configuration;
    }

    public SmppCommand createSmppCommand(SMPPSession session, Exchange exchange) {
        SmppCommandType commandType = SmppCommandType.fromExchange(exchange);
        return commandType.createCommand(session, this.configuration);
    }

    public SmppMessage createSmppMessage(CamelContext camelContext, AlertNotification alertNotification) {
        SmppMessage smppMessage = new SmppMessage(camelContext, alertNotification, this.configuration);
        smppMessage.setHeader("CamelSmppMessageType", SmppMessageType.AlertNotification.toString());
        smppMessage.setHeader("CamelSmppSequenceNumber", alertNotification.getSequenceNumber());
        smppMessage.setHeader("CamelSmppCommandId", alertNotification.getCommandId());
        smppMessage.setHeader("CamelSmppCommandStatus", alertNotification.getCommandStatus());
        smppMessage.setHeader("CamelSmppSourceAddr", alertNotification.getSourceAddr());
        smppMessage.setHeader("CamelSmppSourceAddrNpi", alertNotification.getSourceAddrNpi());
        smppMessage.setHeader("CamelSmppSourceAddrTon", alertNotification.getSourceAddrTon());
        smppMessage.setHeader("CamelSmppEsmeAddr", alertNotification.getEsmeAddr());
        smppMessage.setHeader("CamelSmppEsmeAddrNpi", alertNotification.getEsmeAddrNpi());
        smppMessage.setHeader("CamelSmppEsmeAddrTon", alertNotification.getEsmeAddrTon());
        return smppMessage;
    }

    public SmppMessage createSmppMessage(CamelContext camelContext, DeliverSm deliverSm) throws Exception {
        SmppMessage smppMessage = new SmppMessage(camelContext, deliverSm, this.configuration);
        byte[] body = SmppUtils.getMessageBody(deliverSm);
        String decodedBody = SmppUtils.decodeBody(body, deliverSm.getDataCoding(), this.configuration.getEncoding());
        if (deliverSm.isSmscDeliveryReceipt()) {
            smppMessage.setHeader("CamelSmppMessageType", SmppMessageType.DeliveryReceipt.toString());
            DeliveryReceipt smscDeliveryReceipt = null;
            if (decodedBody != null) {
                smscDeliveryReceipt = DefaultDecomposer.getInstance().deliveryReceipt(decodedBody);
            } else if (body != null) {
                smscDeliveryReceipt = DefaultDecomposer.getInstance().deliveryReceipt(body);
            }
            if (smscDeliveryReceipt != null) {
                smppMessage.setBody(smscDeliveryReceipt.getText());
                smppMessage.setHeader("CamelSmppId", smscDeliveryReceipt.getId());
                smppMessage.setHeader("CamelSmppDelivered", smscDeliveryReceipt.getDelivered());
                smppMessage.setHeader("CamelSmppDoneDate", smscDeliveryReceipt.getDoneDate());
                if (!"000".equals(smscDeliveryReceipt.getError())) {
                    smppMessage.setHeader("CamelSmppError", smscDeliveryReceipt.getError());
                }
                smppMessage.setHeader("CamelSmppSubmitDate", smscDeliveryReceipt.getSubmitDate());
                smppMessage.setHeader("CamelSmppSubmitted", smscDeliveryReceipt.getSubmitted());
                smppMessage.setHeader("CamelSmppStatus", (Object)smscDeliveryReceipt.getFinalStatus());
            }
        } else {
            smppMessage.setHeader("CamelSmppMessageType", SmppMessageType.DeliverSm.toString());
            if (body != null) {
                smppMessage.setBody(decodedBody != null ? decodedBody : (Object)body);
            }
            smppMessage.setHeader("CamelSmppSequenceNumber", deliverSm.getSequenceNumber());
            smppMessage.setHeader("CamelSmppCommandId", deliverSm.getCommandId());
            smppMessage.setHeader("CamelSmppSourceAddr", deliverSm.getSourceAddr());
            smppMessage.setHeader("CamelSmppSourceAddrNpi", deliverSm.getSourceAddrNpi());
            smppMessage.setHeader("CamelSmppSourceAddrTon", deliverSm.getSourceAddrTon());
            smppMessage.setHeader("CamelSmppDataCoding", deliverSm.getDataCoding());
            smppMessage.setHeader("CamelSmppDestAddr", deliverSm.getDestAddress());
            smppMessage.setHeader("CamelSmppDestAddrNpi", deliverSm.getDestAddrNpi());
            smppMessage.setHeader("CamelSmppDestAddrTon", deliverSm.getDestAddrTon());
            smppMessage.setHeader("CamelSmppScheduleDeliveryTime", deliverSm.getScheduleDeliveryTime());
            smppMessage.setHeader("CamelSmppValidityPeriod", deliverSm.getValidityPeriod());
            smppMessage.setHeader("CamelSmppServiceType", deliverSm.getServiceType());
        }
        if (deliverSm.getOptionalParameters() != null && deliverSm.getOptionalParameters().length > 0) {
            Map<String, Object> optionalParameters = this.createOptionalParameterByName(deliverSm);
            smppMessage.setHeader("CamelSmppOptionalParameters", optionalParameters);
            Map<Short, Object> optionalParameter = this.createOptionalParameterByCode(deliverSm);
            smppMessage.setHeader("CamelSmppOptionalParameter", optionalParameter);
        }
        return smppMessage;
    }

    private Map<String, Object> createOptionalParameterByName(DeliverSm deliverSm) {
        HashMap<String, Object> optParams = new HashMap<String, Object>();
        for (OptionalParameter optPara : deliverSm.getOptionalParameters()) {
            try {
                OptionalParameter.Tag valueOfTag = OptionalParameter.Tag.valueOf(optPara.tag);
                if (valueOfTag != null) {
                    if (optPara instanceof OptionalParameter.COctetString) {
                        optParams.put(valueOfTag.toString(), ((OptionalParameter.COctetString)optPara).getValueAsString());
                        continue;
                    }
                    if (optPara instanceof OptionalParameter.OctetString) {
                        optParams.put(valueOfTag.toString(), ((OptionalParameter.OctetString)optPara).getValueAsString());
                        continue;
                    }
                    if (optPara instanceof OptionalParameter.Byte) {
                        optParams.put(valueOfTag.toString(), ((OptionalParameter.Byte)optPara).getValue());
                        continue;
                    }
                    if (optPara instanceof OptionalParameter.Short) {
                        optParams.put(valueOfTag.toString(), ((OptionalParameter.Short)optPara).getValue());
                        continue;
                    }
                    if (optPara instanceof OptionalParameter.Int) {
                        optParams.put(valueOfTag.toString(), ((OptionalParameter.Int)optPara).getValue());
                        continue;
                    }
                    if (!(optPara instanceof OptionalParameter.Null)) continue;
                    optParams.put(valueOfTag.toString(), null);
                    continue;
                }
                LOG.debug("Skipping optional parameter with tag {} because it was not recognized", (Object)optPara.tag);
            }
            catch (IllegalArgumentException e) {
                LOG.debug("Skipping optional parameter with tag {} due to {}", (Object)optPara.tag, (Object)e.getMessage());
            }
        }
        return optParams;
    }

    private Map<Short, Object> createOptionalParameterByCode(DeliverSm deliverSm) {
        HashMap<Short, Object> optParams = new HashMap<Short, Object>();
        for (OptionalParameter optPara : deliverSm.getOptionalParameters()) {
            if (optPara instanceof OptionalParameter.COctetString) {
                optParams.put(optPara.tag, ((OptionalParameter.COctetString)optPara).getValueAsString());
                continue;
            }
            if (optPara instanceof OptionalParameter.OctetString) {
                optParams.put(optPara.tag, ((OptionalParameter.OctetString)optPara).getValue());
                continue;
            }
            if (optPara instanceof OptionalParameter.Byte) {
                optParams.put(optPara.tag, ((OptionalParameter.Byte)optPara).getValue());
                continue;
            }
            if (optPara instanceof OptionalParameter.Short) {
                optParams.put(optPara.tag, ((OptionalParameter.Short)optPara).getValue());
                continue;
            }
            if (optPara instanceof OptionalParameter.Int) {
                optParams.put(optPara.tag, ((OptionalParameter.Int)optPara).getValue());
                continue;
            }
            if (!(optPara instanceof OptionalParameter.Null)) continue;
            optParams.put(optPara.tag, null);
        }
        return optParams;
    }

    public SmppMessage createSmppMessage(CamelContext camelContext, DataSm dataSm, String smppMessageId) {
        SmppMessage smppMessage = new SmppMessage(camelContext, dataSm, this.configuration);
        smppMessage.setHeader("CamelSmppMessageType", SmppMessageType.DataSm.toString());
        smppMessage.setHeader("CamelSmppId", smppMessageId);
        smppMessage.setHeader("CamelSmppSequenceNumber", dataSm.getSequenceNumber());
        smppMessage.setHeader("CamelSmppCommandId", dataSm.getCommandId());
        smppMessage.setHeader("CamelSmppCommandStatus", dataSm.getCommandStatus());
        smppMessage.setHeader("CamelSmppSourceAddr", dataSm.getSourceAddr());
        smppMessage.setHeader("CamelSmppSourceAddrNpi", dataSm.getSourceAddrNpi());
        smppMessage.setHeader("CamelSmppSourceAddrTon", dataSm.getSourceAddrTon());
        smppMessage.setHeader("CamelSmppDestAddr", dataSm.getDestAddress());
        smppMessage.setHeader("CamelSmppDestAddrNpi", dataSm.getDestAddrNpi());
        smppMessage.setHeader("CamelSmppDestAddrTon", dataSm.getDestAddrTon());
        smppMessage.setHeader("CamelSmppServiceType", dataSm.getServiceType());
        smppMessage.setHeader("CamelSmppRegisteredDelivery", dataSm.getRegisteredDelivery());
        smppMessage.setHeader("CamelSmppDataCoding", dataSm.getDataCoding());
        return smppMessage;
    }

    Date getCurrentDate() {
        return new Date();
    }

    public SmppConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(SmppConfiguration configuration) {
        this.configuration = configuration;
    }
}

