/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.smpp;

import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.smpp.AbstractSmppCommand;
import org.apache.camel.component.smpp.SmppConfiguration;
import org.apache.camel.component.smpp.SmppException;
import org.apache.camel.component.smpp.SmppUtils;
import org.apache.camel.support.ExchangeHelper;
import org.jsmpp.bean.NumberingPlanIndicator;
import org.jsmpp.bean.QuerySm;
import org.jsmpp.bean.TypeOfNumber;
import org.jsmpp.session.QuerySmResult;
import org.jsmpp.session.SMPPSession;

public class SmppQuerySmCommand
extends AbstractSmppCommand {
    public SmppQuerySmCommand(SMPPSession session, SmppConfiguration config) {
        super(session, config);
    }

    @Override
    public void execute(Exchange exchange) throws SmppException {
        QuerySmResult querySmResult;
        QuerySm querySm = this.createQuerySm(exchange);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Querying for a short message for exchange id '{}' and message id '{}'...", (Object)exchange.getExchangeId(), (Object)querySm.getMessageId());
        }
        try {
            querySmResult = this.session.queryShortMessage(querySm.getMessageId(), TypeOfNumber.valueOf(querySm.getSourceAddrTon()), NumberingPlanIndicator.valueOf(querySm.getSourceAddrNpi()), querySm.getSourceAddr());
        }
        catch (Exception e) {
            throw new SmppException(e);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Query for a short message for exchange id '{}' and message id '{}'", (Object)exchange.getExchangeId(), (Object)querySm.getMessageId());
        }
        Message message = ExchangeHelper.getResultMessage(exchange);
        message.setHeader("CamelSmppId", querySm.getMessageId());
        message.setHeader("CamelSmppError", querySmResult.getErrorCode());
        message.setHeader("CamelSmppFinalDate", SmppUtils.string2Date(querySmResult.getFinalDate()));
        message.setHeader("CamelSmppMessageState", querySmResult.getMessageState().name());
    }

    protected QuerySm createQuerySm(Exchange exchange) {
        Message in = exchange.getIn();
        QuerySm querySm = new QuerySm();
        if (in.getHeaders().containsKey("CamelSmppId")) {
            querySm.setMessageId(in.getHeader("CamelSmppId", String.class));
        }
        if (in.getHeaders().containsKey("CamelSmppSourceAddr")) {
            querySm.setSourceAddr(in.getHeader("CamelSmppSourceAddr", String.class));
        } else {
            querySm.setSourceAddr(this.config.getSourceAddr());
        }
        if (in.getHeaders().containsKey("CamelSmppSourceAddrTon")) {
            querySm.setSourceAddrTon(in.getHeader("CamelSmppSourceAddrTon", Byte.class));
        } else {
            querySm.setSourceAddrTon(this.config.getSourceAddrTon());
        }
        if (in.getHeaders().containsKey("CamelSmppSourceAddrNpi")) {
            querySm.setSourceAddrNpi(in.getHeader("CamelSmppSourceAddrNpi", Byte.class));
        } else {
            querySm.setSourceAddrNpi(this.config.getSourceAddrNpi());
        }
        return querySm;
    }
}

