/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp;

import java.io.IOException;
import java.io.OutputStream;
import org.jsmpp.InvalidNumberOfDestinationsException;
import org.jsmpp.PDUSender;
import org.jsmpp.PDUStringException;
import org.jsmpp.bean.BindType;
import org.jsmpp.bean.DataCoding;
import org.jsmpp.bean.DestinationAddress;
import org.jsmpp.bean.ESMClass;
import org.jsmpp.bean.InterfaceVersion;
import org.jsmpp.bean.MessageState;
import org.jsmpp.bean.NumberingPlanIndicator;
import org.jsmpp.bean.OptionalParameter;
import org.jsmpp.bean.OptionalParameters;
import org.jsmpp.bean.RegisteredDelivery;
import org.jsmpp.bean.ReplaceIfPresentFlag;
import org.jsmpp.bean.TypeOfNumber;
import org.jsmpp.bean.UnsuccessDelivery;
import org.jsmpp.util.DefaultComposer;
import org.jsmpp.util.HexUtil;
import org.jsmpp.util.OctetUtil;
import org.jsmpp.util.PDUComposer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPDUSender
implements PDUSender {
    private static final Logger log = LoggerFactory.getLogger(DefaultPDUSender.class);
    private static final byte[] EMPTY_SHORT_MESSAGE = new byte[0];
    private final PDUComposer pduComposer;

    public DefaultPDUSender() {
        this(new DefaultComposer());
    }

    public DefaultPDUSender(PDUComposer pduComposer) {
        this.pduComposer = pduComposer;
    }

    @Override
    public byte[] sendHeader(OutputStream os, int commandId, int commandStatus, int sequenceNumber) throws IOException {
        byte[] b = this.pduComposer.composeHeader(commandId, commandStatus, sequenceNumber);
        DefaultPDUSender.writeAndFlush(os, b);
        return b;
    }

    @Override
    public byte[] sendBind(OutputStream os, BindType bindType, int sequenceNumber, String systemId, String password, String systemType, InterfaceVersion interfaceVersion, TypeOfNumber addrTon, NumberingPlanIndicator addrNpi, String addressRange) throws PDUStringException, IOException {
        byte[] b = this.pduComposer.bind(bindType.commandId(), sequenceNumber, systemId, password, systemType, interfaceVersion.value(), addrTon.value(), addrNpi.value(), addressRange);
        DefaultPDUSender.writeAndFlush(os, b);
        return b;
    }

    @Override
    public byte[] sendBindResp(OutputStream os, int commandId, int sequenceNumber, String systemId, InterfaceVersion interfaceVersion) throws PDUStringException, IOException {
        OptionalParameter[] optionalParameters;
        if (interfaceVersion != null) {
            OptionalParameter.Byte interfaceVersionParam = new OptionalParameter.Byte(OptionalParameter.Tag.SC_INTERFACE_VERSION, interfaceVersion.value());
            optionalParameters = new OptionalParameter[]{interfaceVersionParam};
        } else {
            optionalParameters = OptionalParameters.EMPTY_OPTIONAL_PARAMETERS;
        }
        byte[] b = this.pduComposer.bindResp(commandId, sequenceNumber, systemId, optionalParameters);
        DefaultPDUSender.writeAndFlush(os, b);
        return b;
    }

    @Override
    public byte[] sendOutbind(OutputStream os, int sequenceNumber, String systemId, String password) throws PDUStringException, IOException {
        byte[] b = this.pduComposer.outbind(sequenceNumber, systemId, password);
        DefaultPDUSender.writeAndFlush(os, b);
        return b;
    }

    @Override
    public byte[] sendUnbind(OutputStream os, int sequenceNumber) throws IOException {
        byte[] b = this.pduComposer.unbind(sequenceNumber);
        DefaultPDUSender.writeAndFlush(os, b);
        return b;
    }

    @Override
    public byte[] sendGenericNack(OutputStream os, int commandStatus, int sequenceNumber) throws IOException {
        byte[] b = this.pduComposer.genericNack(commandStatus, sequenceNumber);
        DefaultPDUSender.writeAndFlush(os, b);
        return b;
    }

    @Override
    public byte[] sendUnbindResp(OutputStream os, int commandStatus, int sequenceNumber) throws IOException {
        byte[] b = this.pduComposer.unbindResp(commandStatus, sequenceNumber);
        DefaultPDUSender.writeAndFlush(os, b);
        return b;
    }

    @Override
    public byte[] sendEnquireLink(OutputStream os, int sequenceNumber) throws IOException {
        byte[] b = this.pduComposer.enquireLink(sequenceNumber);
        DefaultPDUSender.writeAndFlush(os, b);
        return b;
    }

    @Override
    public byte[] sendEnquireLinkResp(OutputStream os, int sequenceNumber) throws IOException {
        byte[] b = this.pduComposer.enquireLinkResp(sequenceNumber);
        DefaultPDUSender.writeAndFlush(os, b);
        return b;
    }

    @Override
    public byte[] sendSubmitSm(OutputStream os, int sequenceNumber, String serviceType, TypeOfNumber sourceAddrTon, NumberingPlanIndicator sourceAddrNpi, String sourceAddr, TypeOfNumber destAddrTon, NumberingPlanIndicator destAddrNpi, String destinationAddr, ESMClass esmClass, byte protocolId, byte priorityFlag, String scheduleDeliveryTime, String validityPeriod, RegisteredDelivery registeredDelivery, byte replaceIfPresent, DataCoding dataCoding, byte smDefaultMsgId, byte[] shortMessage, OptionalParameter ... optionalParameters) throws PDUStringException, IOException {
        byte[] b = this.pduComposer.submitSm(sequenceNumber, serviceType, sourceAddrTon.value(), sourceAddrNpi.value(), sourceAddr, destAddrTon.value(), destAddrNpi.value(), destinationAddr, esmClass.value(), protocolId, priorityFlag, scheduleDeliveryTime, validityPeriod, registeredDelivery.value(), replaceIfPresent, dataCoding.toByte(), smDefaultMsgId, this.checkShortMessage(shortMessage), optionalParameters);
        DefaultPDUSender.writeAndFlush(os, b);
        return b;
    }

    @Override
    public byte[] sendSubmitSmResp(OutputStream os, int sequenceNumber, String messageId, OptionalParameter ... optionalParameters) throws PDUStringException, IOException {
        byte[] b = this.pduComposer.submitSmResp(sequenceNumber, messageId, optionalParameters);
        DefaultPDUSender.writeAndFlush(os, b);
        return b;
    }

    @Override
    public byte[] sendQuerySm(OutputStream os, int sequenceNumber, String messageId, TypeOfNumber sourceAddrTon, NumberingPlanIndicator sourceAddrNpi, String sourceAddr) throws PDUStringException, IOException {
        byte[] b = this.pduComposer.querySm(sequenceNumber, messageId, sourceAddrTon.value(), sourceAddrNpi.value(), sourceAddr);
        DefaultPDUSender.writeAndFlush(os, b);
        return b;
    }

    @Override
    public byte[] sendQuerySmResp(OutputStream os, int sequenceNumber, String messageId, String finalDate, MessageState messageState, byte errorCode) throws PDUStringException, IOException {
        byte[] b = this.pduComposer.querySmResp(sequenceNumber, messageId, finalDate, messageState.value(), errorCode);
        DefaultPDUSender.writeAndFlush(os, b);
        return b;
    }

    @Override
    public byte[] sendDeliverSm(OutputStream os, int sequenceNumber, String serviceType, TypeOfNumber sourceAddrTon, NumberingPlanIndicator sourceAddrNpi, String sourceAddr, TypeOfNumber destAddrTon, NumberingPlanIndicator destAddrNpi, String destinationAddr, ESMClass esmClass, byte protocolId, byte priorityFlag, RegisteredDelivery registeredDelivery, DataCoding dataCoding, byte[] shortMessage, OptionalParameter ... optionalParameters) throws PDUStringException, IOException {
        byte[] b = this.pduComposer.deliverSm(sequenceNumber, serviceType, sourceAddrTon.value(), sourceAddrNpi.value(), sourceAddr, destAddrTon.value(), destAddrNpi.value(), destinationAddr, esmClass.value(), protocolId, priorityFlag, registeredDelivery.value(), dataCoding.toByte(), this.checkShortMessage(shortMessage), optionalParameters);
        DefaultPDUSender.writeAndFlush(os, b);
        return b;
    }

    @Override
    public byte[] sendDeliverSmResp(OutputStream os, int commandStatus, int sequenceNumber, String messageId) throws IOException {
        byte[] b = this.pduComposer.deliverSmResp(commandStatus, sequenceNumber, messageId);
        DefaultPDUSender.writeAndFlush(os, b);
        return b;
    }

    @Override
    public byte[] sendDataSm(OutputStream os, int sequenceNumber, String serviceType, TypeOfNumber sourceAddrTon, NumberingPlanIndicator sourceAddrNpi, String sourceAddr, TypeOfNumber destAddrTon, NumberingPlanIndicator destAddrNpi, String destinationAddr, ESMClass esmClass, RegisteredDelivery registeredDelivery, DataCoding dataCoding, OptionalParameter ... optionalParameters) throws PDUStringException, IOException {
        byte[] b = this.pduComposer.dataSm(sequenceNumber, serviceType, sourceAddrTon.value(), sourceAddrNpi.value(), sourceAddr, destAddrTon.value(), destAddrNpi.value(), destinationAddr, esmClass.value(), registeredDelivery.value(), dataCoding.toByte(), optionalParameters);
        DefaultPDUSender.writeAndFlush(os, b);
        return b;
    }

    @Override
    public byte[] sendDataSmResp(OutputStream os, int sequenceNumber, String messageId, OptionalParameter ... optionalParameters) throws PDUStringException, IOException {
        return this.sendDataSmResp(os, 0, messageId, optionalParameters);
    }

    @Override
    public byte[] sendDataSmResp(OutputStream os, int commandStatus, int sequenceNumber, String messageId, OptionalParameter ... optionalParameters) throws PDUStringException, IOException {
        byte[] b = this.pduComposer.dataSmResp(commandStatus, sequenceNumber, messageId, optionalParameters);
        DefaultPDUSender.writeAndFlush(os, b);
        return b;
    }

    @Override
    public byte[] sendCancelSm(OutputStream os, int sequenceNumber, String serviceType, String messageId, TypeOfNumber sourceAddrTon, NumberingPlanIndicator sourceAddrNpi, String sourceAddr, TypeOfNumber destAddrTon, NumberingPlanIndicator destAddrNpi, String destinationAddr) throws PDUStringException, IOException {
        byte[] b = this.pduComposer.cancelSm(sequenceNumber, serviceType, messageId, sourceAddrTon.value(), sourceAddrNpi.value(), sourceAddr, destAddrTon.value(), destAddrNpi.value(), destinationAddr);
        DefaultPDUSender.writeAndFlush(os, b);
        return b;
    }

    @Override
    public byte[] sendCancelSmResp(OutputStream os, int sequenceNumber) throws IOException {
        byte[] b = this.pduComposer.cancelSmResp(sequenceNumber);
        DefaultPDUSender.writeAndFlush(os, b);
        return b;
    }

    @Override
    public byte[] sendReplaceSm(OutputStream os, int sequenceNumber, String messageId, TypeOfNumber sourceAddrTon, NumberingPlanIndicator sourceAddrNpi, String sourceAddr, String scheduleDeliveryTime, String validityPeriod, RegisteredDelivery registeredDelivery, byte smDefaultMsgId, byte[] shortMessage) throws PDUStringException, IOException {
        byte[] b = this.pduComposer.replaceSm(sequenceNumber, messageId, sourceAddrTon.value(), sourceAddrNpi.value(), sourceAddr, scheduleDeliveryTime, validityPeriod, registeredDelivery.value(), smDefaultMsgId, this.checkShortMessage(shortMessage));
        DefaultPDUSender.writeAndFlush(os, b);
        return b;
    }

    @Override
    public byte[] sendReplaceSmResp(OutputStream os, int sequenceNumber) throws IOException {
        byte[] b = this.pduComposer.replaceSmResp(sequenceNumber);
        DefaultPDUSender.writeAndFlush(os, b);
        return b;
    }

    @Override
    public byte[] sendSubmitMulti(OutputStream os, int sequenceNumber, String serviceType, TypeOfNumber sourceAddrTon, NumberingPlanIndicator sourceAddrNpi, String sourceAddr, DestinationAddress[] destinationAddresses, ESMClass esmClass, byte protocolId, byte priorityFlag, String scheduleDeliveryTime, String validityPeriod, RegisteredDelivery registeredDelivery, ReplaceIfPresentFlag replaceIfPresentFlag, DataCoding dataCoding, byte smDefaultMsgId, byte[] shortMessage, OptionalParameter ... optionalParameters) throws PDUStringException, InvalidNumberOfDestinationsException, IOException {
        byte[] b = this.pduComposer.submitMulti(sequenceNumber, serviceType, sourceAddrTon.value(), sourceAddrNpi.value(), sourceAddr, destinationAddresses, esmClass.value(), protocolId, priorityFlag, scheduleDeliveryTime, validityPeriod, registeredDelivery.value(), replaceIfPresentFlag.value(), dataCoding.toByte(), smDefaultMsgId, this.checkShortMessage(shortMessage), optionalParameters);
        DefaultPDUSender.writeAndFlush(os, b);
        return b;
    }

    @Override
    public byte[] sendSubmitMultiResp(OutputStream os, int sequenceNumber, String messageId, UnsuccessDelivery ... unsuccessDeliveries) throws PDUStringException, IOException {
        byte[] b = this.pduComposer.submitMultiResp(sequenceNumber, messageId, unsuccessDeliveries);
        DefaultPDUSender.writeAndFlush(os, b);
        return b;
    }

    @Override
    public byte[] sendAlertNotification(OutputStream os, int sequenceNumber, TypeOfNumber sourceAddrTon, NumberingPlanIndicator sourceAddrNpi, String sourceAddr, TypeOfNumber esmeAddrTon, NumberingPlanIndicator esmeAddrNpi, String esmeAddr, OptionalParameter ... optionalParameters) throws PDUStringException, IOException {
        byte[] b = this.pduComposer.alertNotification(sequenceNumber, sourceAddrTon.value(), sourceAddrNpi.value(), sourceAddr, esmeAddrTon.value(), esmeAddrNpi.value(), esmeAddr, optionalParameters);
        DefaultPDUSender.writeAndFlush(os, b);
        return b;
    }

    @Override
    public byte[] sendBroadcastSm(OutputStream os, int sequenceNumber, String serviceType, TypeOfNumber sourceAddrTon, NumberingPlanIndicator sourceAddrNpi, String sourceAddr, String messageId, byte priorityFlag, String scheduleDeliveryTime, String validityPeriod, ReplaceIfPresentFlag replaceIfPresentFlag, DataCoding dataCoding, byte smDefaultMsgId, OptionalParameter ... optionalParameters) throws PDUStringException, IOException {
        byte[] b = this.pduComposer.broadcastSm(sequenceNumber, serviceType, sourceAddrTon.value(), sourceAddrNpi.value(), sourceAddr, messageId, priorityFlag, scheduleDeliveryTime, validityPeriod, replaceIfPresentFlag.value(), dataCoding.toByte(), smDefaultMsgId, optionalParameters);
        DefaultPDUSender.writeAndFlush(os, b);
        return b;
    }

    @Override
    public byte[] sendBroadcastSmResp(OutputStream os, int sequenceNumber, String messageId, OptionalParameter ... optionalParameters) throws PDUStringException, IOException {
        byte[] b = this.pduComposer.broadcastSmResp(sequenceNumber, messageId, optionalParameters);
        DefaultPDUSender.writeAndFlush(os, b);
        return b;
    }

    @Override
    public byte[] sendCancelBroadcastSm(OutputStream os, int sequenceNumber, String serviceType, String messageId, TypeOfNumber sourceAddrTon, NumberingPlanIndicator sourceAddrNpi, String sourceAddr, OptionalParameter ... optionalParameters) throws PDUStringException, IOException {
        byte[] b = this.pduComposer.cancelBroadcastSm(sequenceNumber, serviceType, messageId, sourceAddrTon.value(), sourceAddrNpi.value(), sourceAddr, optionalParameters);
        DefaultPDUSender.writeAndFlush(os, b);
        return b;
    }

    @Override
    public byte[] sendCancelBroadcastSmResp(OutputStream os, int sequenceNumber) throws IOException {
        byte[] b = this.pduComposer.cancelBroadcastSmResp(sequenceNumber);
        DefaultPDUSender.writeAndFlush(os, b);
        return b;
    }

    @Override
    public byte[] sendQueryBroadcastSm(OutputStream os, int sequenceNumber, String messageId, TypeOfNumber sourceAddrTon, NumberingPlanIndicator sourceAddrNpi, String sourceAddr, OptionalParameter ... optionalParameters) throws PDUStringException, IOException {
        byte[] b = this.pduComposer.queryBroadcastSm(sequenceNumber, messageId, sourceAddrTon.value(), sourceAddrNpi.value(), sourceAddr, optionalParameters);
        DefaultPDUSender.writeAndFlush(os, b);
        return b;
    }

    @Override
    public byte[] sendQueryBroadcastSmResp(OutputStream os, int sequenceNumber, String messageId, OptionalParameter ... optionalParameters) throws PDUStringException, IOException {
        byte[] b = this.pduComposer.queryBroadcastSmResp(sequenceNumber, messageId, optionalParameters);
        DefaultPDUSender.writeAndFlush(os, b);
        return b;
    }

    private static void writeAndFlush(OutputStream out, byte[] b) throws IOException {
        int commandId = OctetUtil.bytesToInt(b, 4);
        if (commandId == 21 || commandId == -2147483627) {
            if (log.isTraceEnabled()) {
                log.trace("Sending PDU {}", (Object)HexUtil.convertBytesToHexString(b, 0, b.length));
            }
        } else if (log.isDebugEnabled()) {
            log.debug("Sending PDU {}", (Object)HexUtil.convertBytesToHexString(b, 0, b.length));
        }
        out.write(b);
        out.flush();
    }

    private byte[] checkShortMessage(byte[] shortMessage) {
        return shortMessage != null ? shortMessage : EMPTY_SHORT_MESSAGE;
    }
}

