/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.bean;

import java.util.Objects;
import org.jsmpp.bean.Alphabet;
import org.jsmpp.bean.DataCoding;
import org.jsmpp.bean.MessageClass;

public class GeneralDataCoding
implements DataCoding {
    public static final GeneralDataCoding DEFAULT = new GeneralDataCoding();
    private final Alphabet alphabet;
    private final MessageClass messageClass;
    private final boolean compressed;

    public GeneralDataCoding() {
        this(Alphabet.ALPHA_DEFAULT);
    }

    public GeneralDataCoding(Alphabet alphabet) {
        this(alphabet, null);
    }

    public GeneralDataCoding(Alphabet alphabet, MessageClass messageClass) {
        this(alphabet, messageClass, false);
    }

    public GeneralDataCoding(Alphabet alphabet, MessageClass messageClass, boolean compressed) throws IllegalArgumentException {
        if (alphabet == null) {
            throw new IllegalArgumentException("Alphabet is mandatory, can't be null");
        }
        if (messageClass != null && alphabet != Alphabet.ALPHA_DEFAULT && alphabet != Alphabet.ALPHA_8_BIT && alphabet != Alphabet.ALPHA_UCS2 && alphabet != Alphabet.ALPHA_RESERVED_12) {
            throw new IllegalArgumentException("Alphabet is not supported, only default, 8-bit, UCS-2 are allowed with message class specified");
        }
        this.alphabet = alphabet;
        this.messageClass = messageClass;
        this.compressed = compressed;
    }

    public Alphabet getAlphabet() {
        return this.alphabet;
    }

    public MessageClass getMessageClass() {
        return this.messageClass;
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    @Override
    public byte toByte() {
        byte value = this.compressed ? (byte)32 : 0;
        value = (byte)(value | this.alphabet.value());
        if (this.messageClass != null) {
            value = (byte)(value | 0x10);
            value = (byte)(value | this.messageClass.value());
        }
        return value;
    }

    public String toString() {
        return "DataCoding:" + (this.toByte() & 0xFF);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GeneralDataCoding)) {
            return false;
        }
        GeneralDataCoding that = (GeneralDataCoding)o;
        return this.compressed == that.compressed && this.alphabet == that.alphabet && this.messageClass == that.messageClass;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.compressed, this.alphabet, this.messageClass});
    }
}

