/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.bean;

import java.util.Objects;
import org.jsmpp.bean.Alphabet;
import org.jsmpp.bean.DataCoding;
import org.jsmpp.bean.IndicationSense;
import org.jsmpp.bean.IndicationType;

public class MessageWaitingDataCoding
implements DataCoding {
    private final IndicationSense indicationSense;
    private final IndicationType indicationType;
    private final Alphabet alphabet;

    public MessageWaitingDataCoding(IndicationSense indicationSense, IndicationType indicationType) {
        this(indicationSense, indicationType, null);
    }

    public MessageWaitingDataCoding(IndicationSense indicationSense, IndicationType indicationType, Alphabet alphabet) throws IllegalArgumentException {
        if (alphabet != null && (alphabet.isUnspecified() || alphabet.isReserved())) {
            throw new IllegalArgumentException("Supported alphabet for SimpleDataCoding is one of " + (Object)((Object)Alphabet.ALPHA_DEFAULT) + ", " + (Object)((Object)Alphabet.ALPHA_UNSPECIFIED_2) + " or " + (Object)((Object)Alphabet.ALPHA_8_BIT) + " only. Current alphabet is " + (Object)((Object)alphabet));
        }
        this.indicationSense = indicationSense;
        this.indicationType = indicationType;
        this.alphabet = alphabet;
    }

    public boolean isStoreMessage() {
        return this.alphabet != null;
    }

    public Alphabet getAlphabet() {
        return this.alphabet;
    }

    public IndicationSense getIndicationSense() {
        return this.indicationSense;
    }

    public IndicationType getIndicationType() {
        return this.indicationType;
    }

    @Override
    public byte toByte() {
        byte value = 0;
        if (!this.isStoreMessage()) {
            value = -64;
        } else if (this.alphabet.equals((Object)Alphabet.ALPHA_DEFAULT)) {
            value = -48;
        } else if (this.alphabet.equals((Object)Alphabet.ALPHA_UCS2)) {
            value = -32;
        }
        value = (byte)(value | this.indicationSense.value());
        value = (byte)(value | this.indicationType.value());
        return value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MessageWaitingDataCoding)) {
            return false;
        }
        MessageWaitingDataCoding that = (MessageWaitingDataCoding)o;
        return this.indicationSense == that.indicationSense && this.indicationType == that.indicationType && this.alphabet == that.alphabet;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.indicationSense, this.indicationType, this.alphabet});
    }

    public String toString() {
        return "DataCoding:" + (this.toByte() & 0xFF);
    }
}

