/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.bean;

import java.util.Objects;
import org.jsmpp.bean.Alphabet;
import org.jsmpp.bean.DataCoding;
import org.jsmpp.bean.MessageClass;

public class SimpleDataCoding
implements DataCoding {
    private final Alphabet alphabet;
    private final MessageClass messageClass;

    public SimpleDataCoding() {
        this(Alphabet.ALPHA_DEFAULT, MessageClass.CLASS1);
    }

    public SimpleDataCoding(Alphabet alphabet, MessageClass messageClass) throws IllegalArgumentException {
        if (alphabet == null) {
            throw new IllegalArgumentException("Alphabet is mandatory, can't be null");
        }
        if (alphabet.equals((Object)Alphabet.ALPHA_UCS2) || alphabet.isReserved()) {
            throw new IllegalArgumentException("Supported alphabet for SimpleDataCoding does not include " + (Object)((Object)Alphabet.ALPHA_UCS2) + " or reserved alphabet codes. Current alphabet is " + (Object)((Object)alphabet));
        }
        if (messageClass == null) {
            throw new IllegalArgumentException("MessageClass is mandatory, can't be null");
        }
        this.alphabet = alphabet;
        this.messageClass = messageClass;
    }

    public Alphabet getAlphabet() {
        return this.alphabet;
    }

    public MessageClass getMessageClass() {
        return this.messageClass;
    }

    @Override
    public byte toByte() {
        byte value = -16;
        value = (byte)(value | this.alphabet.value());
        value = (byte)(value | this.messageClass.value());
        return value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SimpleDataCoding)) {
            return false;
        }
        SimpleDataCoding that = (SimpleDataCoding)o;
        return this.alphabet == that.alphabet && this.messageClass == that.messageClass;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.alphabet, this.messageClass});
    }

    public String toString() {
        return "DataCoding:" + (this.toByte() & 0xFF);
    }
}

