/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.session;

import java.io.IOException;
import java.io.OutputStream;
import org.jsmpp.PDUSender;
import org.jsmpp.PDUStringException;
import org.jsmpp.bean.BindType;
import org.jsmpp.bean.InterfaceVersion;
import org.jsmpp.bean.NumberingPlanIndicator;
import org.jsmpp.bean.TypeOfNumber;
import org.jsmpp.session.AbstractSendCommandTask;

public class BindCommandTask
extends AbstractSendCommandTask {
    public static final String COMMAND_NAME_BIND = "bind";
    private final BindType bindType;
    private final String systemId;
    private final String password;
    private final String systemType;
    private final InterfaceVersion interfaceVersion;
    private final TypeOfNumber addrTon;
    private final NumberingPlanIndicator addrNpi;
    private final String addressRange;

    public BindCommandTask(PDUSender pduSender, BindType bindType, String systemId, String password, String systemType, InterfaceVersion interfaceVersion, TypeOfNumber addrTon, NumberingPlanIndicator addrNpi, String addressRange) {
        super(pduSender);
        this.bindType = bindType;
        this.systemId = systemId;
        this.password = password;
        this.systemType = systemType;
        this.interfaceVersion = interfaceVersion;
        this.addrTon = addrTon;
        this.addrNpi = addrNpi;
        this.addressRange = addressRange;
    }

    @Override
    public void executeTask(OutputStream out, int sequenceNumber) throws PDUStringException, IOException {
        this.pduSender.sendBind(out, this.bindType, sequenceNumber, this.systemId, this.password, this.systemType, this.interfaceVersion, this.addrTon, this.addrNpi, this.addressRange);
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME_BIND;
    }
}

