/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.smpp;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.smpp.AbstractSmppCommand;
import org.apache.camel.component.smpp.SmppConfiguration;
import org.apache.camel.component.smpp.SmppException;
import org.apache.camel.support.ExchangeHelper;
import org.jsmpp.bean.DataCodings;
import org.jsmpp.bean.DataSm;
import org.jsmpp.bean.ESMClass;
import org.jsmpp.bean.NumberingPlanIndicator;
import org.jsmpp.bean.OptionalParameter;
import org.jsmpp.bean.RegisteredDelivery;
import org.jsmpp.bean.TypeOfNumber;
import org.jsmpp.session.DataSmResult;
import org.jsmpp.session.SMPPSession;

public class SmppDataSmCommand
extends AbstractSmppCommand {
    public SmppDataSmCommand(SMPPSession session, SmppConfiguration config) {
        super(session, config);
    }

    @Override
    public void execute(Exchange exchange) throws SmppException {
        DataSmResult result;
        DataSm dataSm = this.createDataSm(exchange);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Sending a data short message for exchange id '{}'...", (Object)exchange.getExchangeId());
        }
        try {
            result = this.session.dataShortMessage(dataSm.getServiceType(), TypeOfNumber.valueOf(dataSm.getSourceAddrTon()), NumberingPlanIndicator.valueOf(dataSm.getSourceAddrNpi()), dataSm.getSourceAddr(), TypeOfNumber.valueOf(dataSm.getDestAddrTon()), NumberingPlanIndicator.valueOf(dataSm.getDestAddrNpi()), dataSm.getDestAddress(), new ESMClass(dataSm.getEsmClass()), new RegisteredDelivery(dataSm.getRegisteredDelivery()), DataCodings.newInstance(dataSm.getDataCoding()), dataSm.getOptionalParameters());
        }
        catch (Exception e) {
            throw new SmppException(e);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Sent a data short message for exchange id '{}' and message id '{}'", (Object)exchange.getExchangeId(), (Object)result.getMessageId());
        }
        Message message = ExchangeHelper.getResultMessage(exchange);
        message.setHeader("CamelSmppId", result.getMessageId());
        message.setHeader("CamelSmppOptionalParameters", this.createOptionalParameterByName(result.getOptionalParameters()));
        message.setHeader("CamelSmppOptionalParameter", this.createOptionalParameterByCode(result.getOptionalParameters()));
    }

    protected Map<String, String> createOptionalParameterByName(OptionalParameter[] optionalParameters) {
        if (optionalParameters == null) {
            return null;
        }
        HashMap<String, String> optParams = new HashMap<String, String>();
        for (OptionalParameter optionalParameter : optionalParameters) {
            String value = null;
            if (optionalParameter instanceof OptionalParameter.COctetString) {
                value = ((OptionalParameter.COctetString)optionalParameter).getValueAsString();
            } else if (optionalParameter instanceof OptionalParameter.OctetString) {
                value = ((OptionalParameter.OctetString)optionalParameter).getValueAsString();
            } else if (optionalParameter instanceof OptionalParameter.Int) {
                value = String.valueOf(((OptionalParameter.Int)optionalParameter).getValue());
            } else if (optionalParameter instanceof OptionalParameter.Short) {
                value = String.valueOf(((OptionalParameter.Short)optionalParameter).getValue());
            } else if (optionalParameter instanceof OptionalParameter.Byte) {
                value = String.valueOf(((OptionalParameter.Byte)optionalParameter).getValue());
            } else if (optionalParameter instanceof OptionalParameter.Null) {
                value = null;
            }
            optParams.put(OptionalParameter.Tag.valueOf(optionalParameter.tag).name(), value);
        }
        return optParams;
    }

    protected Map<Short, Object> createOptionalParameterByCode(OptionalParameter[] optionalParameters) {
        if (optionalParameters == null) {
            return null;
        }
        HashMap<Short, Object> optParams = new HashMap<Short, Object>();
        for (OptionalParameter optPara : optionalParameters) {
            if (OptionalParameter.COctetString.class.isInstance(optPara)) {
                optParams.put(optPara.tag, ((OptionalParameter.COctetString)optPara).getValueAsString());
                continue;
            }
            if (OptionalParameter.OctetString.class.isInstance(optPara)) {
                optParams.put(optPara.tag, ((OptionalParameter.OctetString)optPara).getValue());
                continue;
            }
            if (OptionalParameter.Byte.class.isInstance(optPara)) {
                optParams.put(optPara.tag, ((OptionalParameter.Byte)optPara).getValue());
                continue;
            }
            if (OptionalParameter.Short.class.isInstance(optPara)) {
                optParams.put(optPara.tag, ((OptionalParameter.Short)optPara).getValue());
                continue;
            }
            if (OptionalParameter.Int.class.isInstance(optPara)) {
                optParams.put(optPara.tag, ((OptionalParameter.Int)optPara).getValue());
                continue;
            }
            if (!OptionalParameter.Null.class.isInstance(optPara)) continue;
            optParams.put(optPara.tag, null);
        }
        return optParams;
    }

    protected DataSm createDataSm(Exchange exchange) {
        Message in = exchange.getIn();
        DataSm dataSm = new DataSm();
        if (in.getHeaders().containsKey("CamelSmppDataCoding")) {
            dataSm.setDataCoding(in.getHeader("CamelSmppDataCoding", Byte.class));
        } else if (in.getHeaders().containsKey("CamelSmppAlphabet")) {
            dataSm.setDataCoding(in.getHeader("CamelSmppAlphabet", Byte.class));
        } else {
            dataSm.setDataCoding(this.config.getDataCoding());
        }
        if (in.getHeaders().containsKey("CamelSmppDestAddr")) {
            dataSm.setDestAddress(in.getHeader("CamelSmppDestAddr", String.class));
        } else {
            dataSm.setDestAddress(this.config.getDestAddr());
        }
        if (in.getHeaders().containsKey("CamelSmppDestAddrTon")) {
            dataSm.setDestAddrTon(in.getHeader("CamelSmppDestAddrTon", Byte.class));
        } else {
            dataSm.setDestAddrTon(this.config.getDestAddrTon());
        }
        if (in.getHeaders().containsKey("CamelSmppDestAddrNpi")) {
            dataSm.setDestAddrNpi(in.getHeader("CamelSmppDestAddrNpi", Byte.class));
        } else {
            dataSm.setDestAddrNpi(this.config.getDestAddrNpi());
        }
        if (in.getHeaders().containsKey("CamelSmppSourceAddr")) {
            dataSm.setSourceAddr(in.getHeader("CamelSmppSourceAddr", String.class));
        } else {
            dataSm.setSourceAddr(this.config.getSourceAddr());
        }
        if (in.getHeaders().containsKey("CamelSmppSourceAddrTon")) {
            dataSm.setSourceAddrTon(in.getHeader("CamelSmppSourceAddrTon", Byte.class));
        } else {
            dataSm.setSourceAddrTon(this.config.getSourceAddrTon());
        }
        if (in.getHeaders().containsKey("CamelSmppSourceAddrNpi")) {
            dataSm.setSourceAddrNpi(in.getHeader("CamelSmppSourceAddrNpi", Byte.class));
        } else {
            dataSm.setSourceAddrNpi(this.config.getSourceAddrNpi());
        }
        if (in.getHeaders().containsKey("CamelSmppServiceType")) {
            dataSm.setServiceType(in.getHeader("CamelSmppServiceType", String.class));
        } else {
            dataSm.setServiceType(this.config.getServiceType());
        }
        if (in.getHeaders().containsKey("CamelSmppRegisteredDelivery")) {
            dataSm.setRegisteredDelivery(in.getHeader("CamelSmppRegisteredDelivery", Byte.class));
        } else {
            dataSm.setRegisteredDelivery(this.config.getRegisteredDelivery());
        }
        Map optinalParamater = in.getHeader("CamelSmppOptionalParameter", Map.class);
        if (optinalParamater != null) {
            List<OptionalParameter> optParams = this.createOptionalParametersByCode(optinalParamater);
            dataSm.setOptionalParameters(optParams.toArray(new OptionalParameter[0]));
        } else {
            Map optinalParamaters = in.getHeader("CamelSmppOptionalParameters", Map.class);
            if (optinalParamaters != null) {
                List<OptionalParameter> optParams = this.createOptionalParametersByName(optinalParamaters);
                dataSm.setOptionalParameters(optParams.toArray(new OptionalParameter[0]));
            } else {
                dataSm.setOptionalParameters(new OptionalParameter[0]);
            }
        }
        return dataSm;
    }
}

