/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.smpp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.smpp.SmppConfiguration;
import org.apache.camel.component.smpp.SmppException;
import org.apache.camel.component.smpp.SmppSmCommand;
import org.apache.camel.component.smpp.SmppUtils;
import org.apache.camel.support.ExchangeHelper;
import org.jsmpp.bean.Address;
import org.jsmpp.bean.DataCodings;
import org.jsmpp.bean.DestinationAddress;
import org.jsmpp.bean.ESMClass;
import org.jsmpp.bean.GSMSpecificFeature;
import org.jsmpp.bean.MessageMode;
import org.jsmpp.bean.MessageType;
import org.jsmpp.bean.NumberingPlanIndicator;
import org.jsmpp.bean.OptionalParameter;
import org.jsmpp.bean.RegisteredDelivery;
import org.jsmpp.bean.ReplaceIfPresentFlag;
import org.jsmpp.bean.SMSCDeliveryReceipt;
import org.jsmpp.bean.SubmitMulti;
import org.jsmpp.bean.TypeOfNumber;
import org.jsmpp.bean.UnsuccessDelivery;
import org.jsmpp.session.SMPPSession;
import org.jsmpp.session.SubmitMultiResult;

public class SmppSubmitMultiCommand
extends SmppSmCommand {
    public SmppSubmitMultiCommand(SMPPSession session, SmppConfiguration config) {
        super(session, config);
    }

    @Override
    public void execute(Exchange exchange) throws SmppException {
        SubmitMulti[] submitMulties = this.createSubmitMulti(exchange);
        ArrayList<SubmitMultiResult> results = new ArrayList<SubmitMultiResult>(submitMulties.length);
        for (SubmitMulti submitMulti : submitMulties) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Sending multiple short messages for exchange id '{}'...", (Object)exchange.getExchangeId());
            }
            try {
                SubmitMultiResult result = this.session.submitMultiple(submitMulti.getServiceType(), TypeOfNumber.valueOf(submitMulti.getSourceAddrTon()), NumberingPlanIndicator.valueOf(submitMulti.getSourceAddrNpi()), submitMulti.getSourceAddr(), (Address[])submitMulti.getDestAddresses(), new ESMClass(submitMulti.getEsmClass()), submitMulti.getProtocolId(), submitMulti.getPriorityFlag(), submitMulti.getScheduleDeliveryTime(), submitMulti.getValidityPeriod(), new RegisteredDelivery(submitMulti.getRegisteredDelivery()), new ReplaceIfPresentFlag(submitMulti.getReplaceIfPresentFlag()), DataCodings.newInstance(submitMulti.getDataCoding()), submitMulti.getSmDefaultMsgId(), submitMulti.getShortMessage(), submitMulti.getOptionalParameters());
                results.add(result);
            }
            catch (Exception e) {
                throw new SmppException(e);
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Sent multiple short messages for exchange id '{}' and received results '{}'", (Object)exchange.getExchangeId(), results);
        }
        ArrayList<String> messageIDs = new ArrayList<String>(results.size());
        HashMap errors = new HashMap();
        for (SubmitMultiResult result : results) {
            UnsuccessDelivery[] deliveries = result.getUnsuccessDeliveries();
            if (deliveries != null) {
                ArrayList undelivered = new ArrayList();
                for (UnsuccessDelivery delivery : deliveries) {
                    HashMap<String, Object> error = new HashMap<String, Object>();
                    error.put("CamelSmppDestAddr", delivery.getDestinationAddress().getAddress());
                    error.put("CamelSmppError", delivery.getErrorStatusCode());
                    undelivered.add(error);
                }
                if (!undelivered.isEmpty()) {
                    errors.put(result.getMessageId(), undelivered);
                }
            }
            messageIDs.add(result.getMessageId());
        }
        Message message = ExchangeHelper.getResultMessage(exchange);
        message.setHeader("CamelSmppId", messageIDs);
        message.setHeader("CamelSmppSentMessageCount", messageIDs.size());
        if (!errors.isEmpty()) {
            message.setHeader("CamelSmppError", errors);
        }
    }

    protected SubmitMulti[] createSubmitMulti(Exchange exchange) throws SmppException {
        Message message = exchange.getIn();
        byte[][] segments = this.splitBody(message);
        SubmitMulti template = this.createSubmitMultiTemplate(exchange);
        ESMClass esmClass = message.getHeader("CamelSmppClass", ESMClass.class);
        if (esmClass != null) {
            template.setEsmClass(esmClass.value());
        } else if (segments.length > 1) {
            template.setEsmClass(new ESMClass(MessageMode.DEFAULT, MessageType.DEFAULT, GSMSpecificFeature.UDHI).value());
        }
        SubmitMulti[] submitMulties = new SubmitMulti[segments.length];
        for (int i = 0; i < segments.length; ++i) {
            SubmitMulti submitMulti = SmppUtils.copySubmitMulti(template);
            submitMulti.setShortMessage(segments[i]);
            submitMulties[i] = submitMulti;
        }
        this.setRegisterDeliveryReceiptFlag(submitMulties, message);
        return submitMulties;
    }

    protected void setRegisterDeliveryReceiptFlag(SubmitMulti[] submitMulties, Message message) {
        byte specifiedDeliveryFlag = this.getRegisterDeliveryFlag(message);
        byte flag = this.getRequestsSingleDLR(message) ? SMSCDeliveryReceipt.DEFAULT.value() : specifiedDeliveryFlag;
        for (int i = 0; i < submitMulties.length - 1; ++i) {
            submitMulties[i].setRegisteredDelivery(flag);
        }
        submitMulties[submitMulties.length - 1].setRegisteredDelivery(specifiedDeliveryFlag);
    }

    protected SubmitMulti createSubmitMultiTemplate(Exchange exchange) {
        Message in = exchange.getIn();
        SubmitMulti submitMulti = new SubmitMulti();
        if (in.getHeaders().containsKey("CamelSmppDataCoding")) {
            submitMulti.setDataCoding(in.getHeader("CamelSmppDataCoding", Byte.class));
        } else if (in.getHeaders().containsKey("CamelSmppAlphabet")) {
            submitMulti.setDataCoding(in.getHeader("CamelSmppAlphabet", Byte.class));
        } else {
            submitMulti.setDataCoding(this.config.getDataCoding());
        }
        byte destAddrTon = in.getHeaders().containsKey("CamelSmppDestAddrTon") ? in.getHeader("CamelSmppDestAddrTon", Byte.class).byteValue() : this.config.getDestAddrTon();
        byte destAddrNpi = in.getHeaders().containsKey("CamelSmppDestAddrNpi") ? in.getHeader("CamelSmppDestAddrNpi", Byte.class).byteValue() : this.config.getDestAddrNpi();
        List<String> destAddresses = in.getHeaders().containsKey("CamelSmppDestAddr") ? in.getHeader("CamelSmppDestAddr", List.class) : Arrays.asList(this.config.getDestAddr());
        DestinationAddress[] addresses = new Address[destAddresses.size()];
        int addrNum = 0;
        for (String destAddr : destAddresses) {
            Address addr = new Address(destAddrTon, destAddrNpi, destAddr);
            addresses[addrNum++] = addr;
        }
        submitMulti.setDestAddresses(addresses);
        if (in.getHeaders().containsKey("CamelSmppSourceAddr")) {
            submitMulti.setSourceAddr(in.getHeader("CamelSmppSourceAddr", String.class));
        } else {
            submitMulti.setSourceAddr(this.config.getSourceAddr());
        }
        if (in.getHeaders().containsKey("CamelSmppSourceAddrTon")) {
            submitMulti.setSourceAddrTon(in.getHeader("CamelSmppSourceAddrTon", Byte.class));
        } else {
            submitMulti.setSourceAddrTon(this.config.getSourceAddrTon());
        }
        if (in.getHeaders().containsKey("CamelSmppSourceAddrNpi")) {
            submitMulti.setSourceAddrNpi(in.getHeader("CamelSmppSourceAddrNpi", Byte.class));
        } else {
            submitMulti.setSourceAddrNpi(this.config.getSourceAddrNpi());
        }
        if (in.getHeaders().containsKey("CamelSmppServiceType")) {
            submitMulti.setServiceType(in.getHeader("CamelSmppServiceType", String.class));
        } else {
            submitMulti.setServiceType(this.config.getServiceType());
        }
        if (in.getHeaders().containsKey("CamelSmppProtocolId")) {
            submitMulti.setProtocolId(in.getHeader("CamelSmppProtocolId", Byte.class));
        } else {
            submitMulti.setProtocolId(this.config.getProtocolId());
        }
        if (in.getHeaders().containsKey("CamelSmppPriorityFlag")) {
            submitMulti.setPriorityFlag(in.getHeader("CamelSmppPriorityFlag", Byte.class));
        } else {
            submitMulti.setPriorityFlag(this.config.getPriorityFlag());
        }
        if (in.getHeaders().containsKey("CamelSmppScheduleDeliveryTime")) {
            submitMulti.setScheduleDeliveryTime(SmppUtils.formatTime(in.getHeader("CamelSmppScheduleDeliveryTime", Date.class)));
        }
        if (in.getHeaders().containsKey("CamelSmppValidityPeriod")) {
            Object validityPeriod = in.getHeader("CamelSmppValidityPeriod");
            if (validityPeriod instanceof String) {
                submitMulti.setValidityPeriod((String)validityPeriod);
            } else if (validityPeriod instanceof Date) {
                submitMulti.setValidityPeriod(SmppUtils.formatTime((Date)validityPeriod));
            }
        }
        if (in.getHeaders().containsKey("CamelSmppReplaceIfPresentFlag")) {
            submitMulti.setReplaceIfPresentFlag(in.getHeader("CamelSmppReplaceIfPresentFlag", Byte.class));
        } else {
            submitMulti.setReplaceIfPresentFlag(this.config.getReplaceIfPresentFlag());
        }
        Map optinalParamater = in.getHeader("CamelSmppOptionalParameter", Map.class);
        if (optinalParamater != null) {
            List<OptionalParameter> optParams = this.createOptionalParametersByCode(optinalParamater);
            submitMulti.setOptionalParameters(optParams.toArray(new OptionalParameter[0]));
        } else {
            Map optinalParamaters = in.getHeader("CamelSmppOptionalParameters", Map.class);
            if (optinalParamaters != null) {
                List<OptionalParameter> optParams = this.createOptionalParametersByName(optinalParamaters);
                submitMulti.setOptionalParameters(optParams.toArray(new OptionalParameter[0]));
            } else {
                submitMulti.setOptionalParameters(new OptionalParameter[0]);
            }
        }
        return submitMulti;
    }
}

