/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.bean;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;
import org.jsmpp.bean.DeliveryReceiptInterface;
import org.jsmpp.util.DeliveryReceiptState;
import org.jsmpp.util.InvalidDeliveryReceiptException;

public class DeliveryReceipt
implements DeliveryReceiptInterface<DeliveryReceiptState> {
    public static final String DELREC_ID = "id";
    public static final String DELREC_SUB = "sub";
    public static final String DELREC_DLVRD = "dlvrd";
    public static final String DELREC_SUBMIT_DATE = "submit date";
    public static final String DELREC_DONE_DATE = "done date";
    public static final String DELREC_STAT = "stat";
    public static final String DELREC_ERR = "err";
    public static final String DELREC_TEXT = "Text";
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyMMddHHmm");
    private String id;
    private Integer submitted;
    private Integer delivered;
    private Date submitDate;
    private Date doneDate;
    private DeliveryReceiptState finalStatus;
    private String error;
    private String text;

    public DeliveryReceipt() {
    }

    public DeliveryReceipt(String formattedDeliveryReceipt) throws InvalidDeliveryReceiptException {
        try {
            this.id = DeliveryReceipt.getDeliveryReceiptValue(DELREC_ID, formattedDeliveryReceipt);
            this.submitted = DeliveryReceipt.getDeliveryReceiptIntValue(DELREC_SUB, formattedDeliveryReceipt);
            this.delivered = DeliveryReceipt.getDeliveryReceiptIntValue(DELREC_DLVRD, formattedDeliveryReceipt);
            this.submitDate = DeliveryReceipt.string2Date(DeliveryReceipt.getDeliveryReceiptValue(DELREC_SUBMIT_DATE, formattedDeliveryReceipt));
            this.doneDate = DeliveryReceipt.string2Date(DeliveryReceipt.getDeliveryReceiptValue(DELREC_DONE_DATE, formattedDeliveryReceipt));
            this.finalStatus = DeliveryReceiptState.getByName(DeliveryReceipt.getDeliveryReceiptValue(DELREC_STAT, formattedDeliveryReceipt));
            this.error = DeliveryReceipt.getDeliveryReceiptValue(DELREC_ERR, formattedDeliveryReceipt);
            this.text = DeliveryReceipt.getDeliveryReceiptTextValue(formattedDeliveryReceipt);
        }
        catch (Exception e) {
            throw new InvalidDeliveryReceiptException("There is an error found when parsing delivery receipt", e);
        }
    }

    public DeliveryReceipt(String id, int submitted, int delivered, Date submitDate, Date doneDate, DeliveryReceiptState finalStatus, String error, String text) {
        this.id = id;
        this.submitted = submitted;
        this.delivered = delivered;
        this.submitDate = submitDate;
        this.doneDate = doneDate;
        this.finalStatus = finalStatus;
        this.error = error;
        this.text = text.length() > 20 ? text.substring(0, 20) : text;
    }

    @Override
    public int getDelivered() {
        return this.delivered;
    }

    public void setDelivered(int delivered) {
        this.delivered = delivered;
    }

    @Override
    public Date getDoneDate() {
        return this.doneDate;
    }

    public void setDoneDate(Date doneDate) {
        this.doneDate = doneDate;
    }

    @Override
    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    @Override
    public DeliveryReceiptState getFinalStatus() {
        return this.finalStatus;
    }

    public void setFinalStatus(DeliveryReceiptState finalStatus) {
        this.finalStatus = finalStatus;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public Date getSubmitDate() {
        return this.submitDate;
    }

    public void setSubmitDate(Date submitDate) {
        this.submitDate = submitDate;
    }

    @Override
    public int getSubmitted() {
        return this.submitted;
    }

    public void setSubmitted(int submitted) {
        this.submitted = submitted;
    }

    @Override
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text != null && text.length() > 20 ? text.substring(0, 20) : text;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(120);
        stringBuilder.append("id:" + this.id).append(" ").append("sub:" + DeliveryReceipt.intToString(this.submitted, 3)).append(" ").append("dlvrd:" + DeliveryReceipt.intToString(this.delivered, 3)).append(" ").append("submit date:" + this.dateFormat.format(this.submitDate)).append(" ").append("done date:" + this.dateFormat.format(this.doneDate)).append(" ").append("stat:" + (Object)((Object)this.finalStatus)).append(" ").append("err:" + this.error).append(" ").append(DELREC_TEXT.toLowerCase() + ":" + this.text);
        return stringBuilder.toString();
    }

    private static String intToString(int value, int digit) {
        StringBuilder stringBuilder = new StringBuilder(digit);
        stringBuilder.append(value);
        while (stringBuilder.length() < digit) {
            stringBuilder.insert(0, "0");
        }
        return stringBuilder.toString();
    }

    private static String getDeliveryReceiptValue(String attrName, String source) {
        String tmpAttr = attrName + ":";
        int startIndex = source.indexOf(tmpAttr);
        if (startIndex < 0) {
            return null;
        }
        int endIndex = source.indexOf(" ", startIndex += tmpAttr.length());
        if (endIndex > 0) {
            return source.substring(startIndex, endIndex);
        }
        return source.substring(startIndex);
    }

    private static Date string2Date(String date) {
        if (date == null) {
            return null;
        }
        int year = Integer.parseInt(date.substring(0, 2));
        int month = Integer.parseInt(date.substring(2, 4));
        int day = Integer.parseInt(date.substring(4, 6));
        int hour = Integer.parseInt(date.substring(6, 8));
        int minute = Integer.parseInt(date.substring(8, 10));
        int second = 0;
        if (date.length() >= 12) {
            second = Integer.parseInt(date.substring(10, 12));
        }
        Calendar cal = Calendar.getInstance();
        cal.set(DeliveryReceipt.convertTwoDigitYear(year), month - 1, day, hour, minute, second);
        cal.set(14, 0);
        return cal.getTime();
    }

    private static int convertTwoDigitYear(int year) {
        if (year >= 0 && year <= 37) {
            return 2000 + year;
        }
        if (year >= 38 && year <= 99) {
            return 1900 + year;
        }
        return year;
    }

    private static String getDeliveryReceiptTextValue(String source) {
        String tmpAttr = "Text:";
        int startIndex = source.indexOf(tmpAttr);
        if (startIndex < 0) {
            tmpAttr = DELREC_TEXT.toLowerCase() + ":";
            startIndex = source.indexOf(tmpAttr);
        }
        if (startIndex < 0) {
            return null;
        }
        return source.substring(startIndex += tmpAttr.length());
    }

    private static int getDeliveryReceiptIntValue(String attrName, String formattedDeliveryReceipt) {
        String value = DeliveryReceipt.getDeliveryReceiptValue(attrName, formattedDeliveryReceipt);
        if (value != null) {
            return Integer.parseInt(value);
        }
        return -1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeliveryReceipt that = (DeliveryReceipt)o;
        return Objects.equals(this.dateFormat, that.dateFormat) && Objects.equals(this.id, that.id) && Objects.equals(this.submitted, that.submitted) && Objects.equals(this.delivered, that.delivered) && Objects.equals(this.submitDate, that.submitDate) && Objects.equals(this.doneDate, that.doneDate) && this.finalStatus == that.finalStatus && Objects.equals(this.error, that.error) && Objects.equals(this.text, that.text);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.dateFormat, this.id, this.submitted, this.delivered, this.submitDate, this.doneDate, this.finalStatus, this.error, this.text});
    }
}

