/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.session;

import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jsmpp.extra.SessionState;
import org.jsmpp.session.AbstractSessionContext;
import org.jsmpp.session.SMPPOutboundServerSession;
import org.jsmpp.session.SessionStateListener;
import org.jsmpp.session.state.SMPPOutboundServerSessionState;

class OutboundSMPPServerSessionContext
extends AbstractSessionContext {
    private SMPPOutboundServerSessionState stateProcessor = SMPPOutboundServerSessionState.CLOSED;
    private final SMPPOutboundServerSession smppSession;
    private final ReadWriteLock stateProcessorLock = new ReentrantReadWriteLock();

    public OutboundSMPPServerSessionContext(SMPPOutboundServerSession smppSession, SessionStateListener sessionStateListener) {
        super(sessionStateListener);
        this.smppSession = smppSession;
    }

    public SMPPOutboundServerSessionState getStateProcessor() {
        try {
            this.stateProcessorLock.readLock().lock();
            SMPPOutboundServerSessionState sMPPOutboundServerSessionState = this.stateProcessor;
            return sMPPOutboundServerSessionState;
        }
        finally {
            this.stateProcessorLock.readLock().unlock();
        }
    }

    @Override
    public SessionState getSessionState() {
        try {
            this.stateProcessorLock.readLock().lock();
            SessionState sessionState = this.stateProcessor.getSessionState();
            return sessionState;
        }
        finally {
            this.stateProcessorLock.readLock().unlock();
        }
    }

    public synchronized void outbind() {
        this.changeState(SessionState.OUTBOUND);
    }

    @Override
    protected void changeState(SessionState newState) {
        if (!this.stateProcessor.getSessionState().equals((Object)newState)) {
            SessionState oldState;
            try {
                this.stateProcessorLock.writeLock().lock();
                oldState = this.stateProcessor.getSessionState();
                if (newState == SessionState.OPEN) {
                    this.stateProcessor = SMPPOutboundServerSessionState.OPEN;
                } else if (newState == SessionState.OUTBOUND) {
                    this.stateProcessor = SMPPOutboundServerSessionState.OUTBOUND;
                } else if (newState == SessionState.BOUND_RX) {
                    this.stateProcessor = SMPPOutboundServerSessionState.BOUND_RX;
                } else if (newState == SessionState.BOUND_TX) {
                    this.stateProcessor = SMPPOutboundServerSessionState.BOUND_TX;
                } else if (newState == SessionState.BOUND_TRX) {
                    this.stateProcessor = SMPPOutboundServerSessionState.BOUND_TRX;
                } else if (newState == SessionState.UNBOUND) {
                    this.stateProcessor = SMPPOutboundServerSessionState.UNBOUND;
                } else if (newState == SessionState.CLOSED) {
                    this.stateProcessor = SMPPOutboundServerSessionState.CLOSED;
                }
            }
            finally {
                this.stateProcessorLock.writeLock().unlock();
            }
            if (oldState != null) {
                this.fireStateChanged(newState, oldState, this.smppSession);
            }
        }
    }
}

