/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.session;

import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jsmpp.extra.SessionState;
import org.jsmpp.session.AbstractSessionContext;
import org.jsmpp.session.SMPPServerSession;
import org.jsmpp.session.state.SMPPServerSessionState;

public class SMPPServerSessionContext
extends AbstractSessionContext {
    private SMPPServerSessionState stateProcessor = SMPPServerSessionState.CLOSED;
    private final SMPPServerSession smppServerSession;
    private final ReadWriteLock stateProcessorLock = new ReentrantReadWriteLock();

    public SMPPServerSessionContext(SMPPServerSession smppServerSession) {
        this.smppServerSession = smppServerSession;
    }

    @Override
    protected void changeState(SessionState newState) {
        if (!this.stateProcessor.getSessionState().equals((Object)newState)) {
            SessionState oldState;
            try {
                this.stateProcessorLock.writeLock().lock();
                oldState = this.stateProcessor.getSessionState();
                if (newState == SessionState.OPEN) {
                    this.stateProcessor = SMPPServerSessionState.OPEN;
                } else if (newState == SessionState.BOUND_RX) {
                    this.stateProcessor = SMPPServerSessionState.BOUND_RX;
                } else if (newState == SessionState.BOUND_TX) {
                    this.stateProcessor = SMPPServerSessionState.BOUND_TX;
                } else if (newState == SessionState.BOUND_TRX) {
                    this.stateProcessor = SMPPServerSessionState.BOUND_TRX;
                } else if (newState == SessionState.UNBOUND) {
                    this.stateProcessor = SMPPServerSessionState.UNBOUND;
                } else if (newState == SessionState.CLOSED) {
                    this.stateProcessor = SMPPServerSessionState.CLOSED;
                }
            }
            finally {
                this.stateProcessorLock.writeLock().unlock();
            }
            if (oldState != null) {
                this.fireStateChanged(newState, oldState, this.smppServerSession);
            }
        }
    }

    public SMPPServerSessionState getStateProcessor() {
        try {
            this.stateProcessorLock.readLock().lock();
            SMPPServerSessionState sMPPServerSessionState = this.stateProcessor;
            return sMPPServerSessionState;
        }
        finally {
            this.stateProcessorLock.readLock().unlock();
        }
    }

    @Override
    public SessionState getSessionState() {
        try {
            this.stateProcessorLock.readLock().lock();
            SessionState sessionState = this.stateProcessor.getSessionState();
            return sessionState;
        }
        finally {
            this.stateProcessorLock.readLock().unlock();
        }
    }
}

