/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.session;

import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jsmpp.extra.SessionState;
import org.jsmpp.session.AbstractSessionContext;
import org.jsmpp.session.SMPPSession;
import org.jsmpp.session.SessionStateListener;
import org.jsmpp.session.state.SMPPSessionState;

public class SMPPSessionContext
extends AbstractSessionContext {
    private final SMPPSession smppSession;
    private SMPPSessionState stateProcessor = SMPPSessionState.CLOSED;
    private final ReadWriteLock stateProcessorLock = new ReentrantReadWriteLock();

    public SMPPSessionContext(SMPPSession smppSession, SessionStateListener sessionStateListener) {
        super(sessionStateListener);
        this.smppSession = smppSession;
    }

    public SMPPSessionState getStateProcessor() {
        try {
            this.stateProcessorLock.readLock().lock();
            SMPPSessionState sMPPSessionState = this.stateProcessor;
            return sMPPSessionState;
        }
        finally {
            this.stateProcessorLock.readLock().unlock();
        }
    }

    @Override
    public SessionState getSessionState() {
        try {
            this.stateProcessorLock.readLock().lock();
            SessionState sessionState = this.stateProcessor.getSessionState();
            return sessionState;
        }
        finally {
            this.stateProcessorLock.readLock().unlock();
        }
    }

    @Override
    protected void changeState(SessionState newState) {
        if (!this.stateProcessor.getSessionState().equals((Object)newState)) {
            SessionState oldState;
            try {
                this.stateProcessorLock.writeLock().lock();
                oldState = this.stateProcessor.getSessionState();
                if (newState == SessionState.OPEN) {
                    this.stateProcessor = SMPPSessionState.OPEN;
                } else if (newState == SessionState.BOUND_RX) {
                    this.stateProcessor = SMPPSessionState.BOUND_RX;
                } else if (newState == SessionState.BOUND_TX) {
                    this.stateProcessor = SMPPSessionState.BOUND_TX;
                } else if (newState == SessionState.BOUND_TRX) {
                    this.stateProcessor = SMPPSessionState.BOUND_TRX;
                } else if (newState == SessionState.UNBOUND) {
                    this.stateProcessor = SMPPSessionState.UNBOUND;
                } else if (newState == SessionState.CLOSED) {
                    this.stateProcessor = SMPPSessionState.CLOSED;
                }
            }
            finally {
                this.stateProcessorLock.writeLock().unlock();
            }
            if (oldState != null) {
                this.fireStateChanged(newState, oldState, this.smppSession);
            }
        }
    }
}

