/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.snmp;

import org.apache.camel.component.snmp.SnmpEndpoint;
import org.snmp4j.CommunityTarget;
import org.snmp4j.PDU;
import org.snmp4j.PDUv1;
import org.snmp4j.ScopedPDU;
import org.snmp4j.Target;
import org.snmp4j.UserTarget;
import org.snmp4j.mp.MPv3;
import org.snmp4j.security.AuthMD5;
import org.snmp4j.security.AuthSHA;
import org.snmp4j.security.Priv3DES;
import org.snmp4j.security.PrivAES128;
import org.snmp4j.security.PrivAES192;
import org.snmp4j.security.PrivAES256;
import org.snmp4j.security.PrivDES;
import org.snmp4j.security.SecurityModels;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.USM;
import org.snmp4j.security.UsmUser;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;

final class SnmpHelper {
    private SnmpHelper() {
    }

    static PDU createPDU(SnmpEndpoint endpoint) {
        return switch (endpoint.getSnmpVersion()) {
            case 0, 1 -> SnmpHelper.createPDU(endpoint.getSnmpVersion());
            case 3 -> SnmpHelper.createScopedPDU(endpoint);
            default -> null;
        };
    }

    static PDU createPDU(int version) {
        return switch (version) {
            case 0 -> new PDUv1();
            case 1 -> new PDU();
            case 3 -> SnmpHelper.createScopedPDU(null);
            default -> null;
        };
    }

    static Target createTarget(SnmpEndpoint endpoint) {
        return switch (endpoint.getSnmpVersion()) {
            case 0, 1 -> SnmpHelper.createCommunityTarget(endpoint);
            case 3 -> SnmpHelper.createUserTarget(endpoint);
            default -> null;
        };
    }

    static USM createAndSetUSM(SnmpEndpoint endpoint) {
        return switch (endpoint.getSnmpVersion()) {
            case 3 -> SnmpHelper.internalCreateAndSetUSM(endpoint);
            default -> null;
        };
    }

    private static USM internalCreateAndSetUSM(SnmpEndpoint endpoint) {
        if (endpoint.getSecurityName() == null) {
            throw new IllegalArgumentException("SecurityNme is required for SNMP v3");
        }
        USM usm = new USM(SecurityProtocols.getInstance(), new OctetString(MPv3.createLocalEngineID()), 0);
        SecurityModels.getInstance().addSecurityModel(usm);
        OID authProtocol = SnmpHelper.convertAuthenticationProtocol(endpoint.getAuthenticationProtocol());
        OctetString authPwd = SnmpHelper.convertToOctetString(endpoint.getAuthenticationPassphrase());
        OID privProtocol = SnmpHelper.convertPrivacyProtocol(endpoint.getPrivacyProtocol());
        OctetString privPwd = SnmpHelper.convertToOctetString(endpoint.getPrivacyPassphrase());
        UsmUser user = new UsmUser(SnmpHelper.convertToOctetString(endpoint.getSecurityName()), authProtocol, authPwd, privProtocol, privPwd);
        usm.addUser(SnmpHelper.convertToOctetString(endpoint.getSecurityName()), user);
        return usm;
    }

    private static ScopedPDU createScopedPDU(SnmpEndpoint endpoint) {
        ScopedPDU scopedPDU = new ScopedPDU();
        if (endpoint != null && endpoint.getSnmpContextEngineId() != null) {
            scopedPDU.setContextEngineID(SnmpHelper.convertToOctetString(endpoint.getSnmpContextEngineId()));
        }
        if (endpoint != null && endpoint.getSnmpContextName() != null) {
            scopedPDU.setContextName(SnmpHelper.convertToOctetString(endpoint.getSnmpContextName()));
        }
        return scopedPDU;
    }

    private static CommunityTarget createCommunityTarget(SnmpEndpoint endpoint) {
        CommunityTarget<Address> communityTarget = new CommunityTarget<Address>();
        communityTarget.setCommunity(SnmpHelper.convertToOctetString(endpoint.getSnmpCommunity()));
        communityTarget.setAddress(GenericAddress.parse(endpoint.getServerAddress()));
        communityTarget.setRetries(endpoint.getRetries());
        communityTarget.setTimeout(endpoint.getTimeout());
        communityTarget.setVersion(endpoint.getSnmpVersion());
        return communityTarget;
    }

    private static UserTarget createUserTarget(SnmpEndpoint endpoint) {
        UserTarget<Address> userTarget = new UserTarget<Address>();
        userTarget.setSecurityLevel(endpoint.getSecurityLevel());
        userTarget.setSecurityName(SnmpHelper.convertToOctetString(endpoint.getSecurityName()));
        userTarget.setAddress(GenericAddress.parse(endpoint.getServerAddress()));
        userTarget.setRetries(endpoint.getRetries());
        userTarget.setTimeout(endpoint.getTimeout());
        userTarget.setVersion(endpoint.getSnmpVersion());
        return userTarget;
    }

    private static OctetString convertToOctetString(String value) {
        if (value == null) {
            return null;
        }
        return new OctetString(value);
    }

    private static OID convertAuthenticationProtocol(String authenticationProtocol) {
        if (authenticationProtocol == null) {
            return null;
        }
        if ("MD5".equals(authenticationProtocol)) {
            return AuthMD5.ID;
        }
        if ("SHA1".equals(authenticationProtocol)) {
            return AuthSHA.ID;
        }
        throw new IllegalArgumentException("Unknown authentication protocol: " + authenticationProtocol);
    }

    private static OID convertPrivacyProtocol(String privacyProtocol) {
        if (privacyProtocol == null) {
            return null;
        }
        if ("DES".equals(privacyProtocol)) {
            return PrivDES.ID;
        }
        if ("TRIDES".equals(privacyProtocol)) {
            return Priv3DES.ID;
        }
        if ("AES128".equals(privacyProtocol)) {
            return PrivAES128.ID;
        }
        if ("AES192".equals(privacyProtocol)) {
            return PrivAES192.ID;
        }
        if ("AES256".equals(privacyProtocol)) {
            return PrivAES256.ID;
        }
        throw new IllegalArgumentException("Unknown privacy protocol: " + privacyProtocol);
    }
}

