/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.snmp;

import org.apache.camel.CamelContext;
import org.apache.camel.component.snmp.SnmpConverters;
import org.apache.camel.support.DefaultMessage;
import org.snmp4j.CommandResponderEvent;
import org.snmp4j.PDU;
import org.snmp4j.smi.OctetString;

public class SnmpMessage
extends DefaultMessage {
    private PDU pdu;

    public SnmpMessage(CamelContext camelContext, PDU pdu) {
        super(camelContext);
        this.pdu = pdu;
    }

    public SnmpMessage(CamelContext camelContext, PDU pdu, CommandResponderEvent event) {
        super(camelContext);
        this.pdu = pdu;
        this.setHeader("securityName", new OctetString(event.getSecurityName()));
        this.setHeader("peerAddress", event.getPeerAddress());
    }

    @Override
    public String toString() {
        if (this.pdu != null) {
            return "SnmpMessage: " + SnmpConverters.toString(this.pdu);
        }
        return "SnmpMessage: " + String.valueOf(this.getBody());
    }

    public PDU getSnmpMessage() {
        return this.pdu;
    }

    @Override
    public SnmpMessage newInstance() {
        return new SnmpMessage(this.getCamelContext(), this.pdu);
    }

    @Override
    protected Object createBody() {
        if (this.pdu != null) {
            return SnmpConverters.toString(this.pdu);
        }
        return null;
    }
}

