/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.security;

import java.util.Hashtable;
import java.util.Map;
import org.snmp4j.security.SecurityModel;
import org.snmp4j.smi.Integer32;

public class SecurityModels {
    private final Map<Integer32, SecurityModel> securityModels = new Hashtable<Integer32, SecurityModel>(3);
    private static SecurityModels instance = null;

    public static synchronized SecurityModels getInstance() {
        if (instance == null) {
            instance = new SecurityModels();
        }
        return instance;
    }

    public static SecurityModels getCollection(SecurityModel[] models) {
        SecurityModels smc = new SecurityModels();
        for (SecurityModel model : models) {
            smc.addSecurityModel(model);
        }
        return smc;
    }

    public SecurityModels addSecurityModel(SecurityModel model) {
        this.securityModels.put(new Integer32(model.getID()), model);
        return this;
    }

    public SecurityModel removeSecurityModel(Integer32 id) {
        return this.securityModels.remove(id);
    }

    public SecurityModel getSecurityModel(Integer32 id) {
        return this.securityModels.get(id);
    }
}

