/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.security;

import java.util.Objects;
import org.snmp4j.SNMP4JSettings;
import org.snmp4j.User;
import org.snmp4j.security.SecretOctetString;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;

public class UsmUser
implements User,
Comparable<UsmUser>,
Cloneable {
    private static final long serialVersionUID = -2258973598142206767L;
    private final OctetString securityName;
    private final SecretOctetString authenticationPassphrase;
    private final SecretOctetString privacyPassphrase;
    private final OID authenticationProtocol;
    private final OID privacyProtocol;
    private OctetString localizationEngineID;
    private LocalizationGrant localizationGrant = LocalizationGrant.any;

    public UsmUser(OctetString securityName, OID authenticationProtocol, OctetString authenticationPassphrase, OID privacyProtocol, OctetString privacyPassphrase) {
        this(securityName, authenticationProtocol, authenticationPassphrase, privacyProtocol, privacyPassphrase, LocalizationGrant.any);
    }

    public UsmUser(OctetString securityName, OID authenticationProtocol, OctetString authenticationPassphrase, OID privacyProtocol, OctetString privacyPassphrase, LocalizationGrant localizationGrant) {
        if (securityName == null) {
            throw new NullPointerException();
        }
        if (SNMP4JSettings.isCheckUsmUserPassphraseLength()) {
            if (authenticationProtocol != null && authenticationPassphrase != null && authenticationPassphrase.length() < 8) {
                throw new IllegalArgumentException("USM passphrases must be at least 8 bytes long (RFC3414 \u00a711.2)");
            }
            if (privacyProtocol != null && privacyPassphrase != null && privacyPassphrase.length() < 8) {
                throw new IllegalArgumentException("USM passphrases must be at least 8 bytes long (RFC3414 \u00a711.2)");
            }
        }
        this.securityName = securityName;
        this.authenticationProtocol = authenticationProtocol;
        this.authenticationPassphrase = SecretOctetString.fromOctetString(authenticationPassphrase);
        this.privacyProtocol = privacyProtocol;
        this.privacyPassphrase = SecretOctetString.fromOctetString(privacyPassphrase);
        this.localizationGrant = localizationGrant;
    }

    public UsmUser(OctetString securityName, OID authenticationProtocol, OctetString authenticationPassphrase, OID privacyProtocol, OctetString privacyPassphrase, OctetString localizationEngineID) {
        if (securityName == null) {
            throw new NullPointerException();
        }
        this.securityName = securityName;
        this.authenticationProtocol = authenticationProtocol;
        this.authenticationPassphrase = SecretOctetString.fromOctetString(authenticationPassphrase);
        this.privacyProtocol = privacyProtocol;
        this.privacyPassphrase = SecretOctetString.fromOctetString(privacyPassphrase);
        this.localizationEngineID = localizationEngineID;
        this.localizationGrant = LocalizationGrant.never;
    }

    public UsmUser(OctetString securityName, OID authenticationProtocol, OctetString authenticationPassphrase, OID privacyProtocol, OctetString privacyPassphrase, OctetString localizationEngineID, LocalizationGrant localizationGrant) {
        this(securityName, authenticationProtocol, authenticationPassphrase, privacyProtocol, privacyPassphrase, localizationEngineID);
        if (localizationEngineID == null) {
            this.localizationGrant = localizationGrant;
        }
    }

    public OctetString getSecurityName() {
        return (OctetString)this.securityName.clone();
    }

    public OID getAuthenticationProtocol() {
        if (this.authenticationProtocol == null) {
            return null;
        }
        return (OID)this.authenticationProtocol.clone();
    }

    public OID getPrivacyProtocol() {
        if (this.privacyProtocol == null) {
            return null;
        }
        return (OID)this.privacyProtocol.clone();
    }

    public OctetString getAuthenticationPassphrase() {
        if (this.authenticationPassphrase == null) {
            return null;
        }
        return (OctetString)this.authenticationPassphrase.clone();
    }

    public OctetString getPrivacyPassphrase() {
        if (this.privacyPassphrase == null) {
            return null;
        }
        return (OctetString)this.privacyPassphrase.clone();
    }

    public OctetString getLocalizationEngineID() {
        return this.localizationEngineID;
    }

    public boolean isLocalized() {
        return this.localizationEngineID != null;
    }

    public boolean isLocalizationGranted(LocalizationGrant requiredLocalizationGrant) {
        LocalizationGrant currentGrant = this.getLocalizationGrant();
        if (currentGrant == LocalizationGrant.never || requiredLocalizationGrant == LocalizationGrant.never) {
            return false;
        }
        if (currentGrant == LocalizationGrant.any) {
            return true;
        }
        return requiredLocalizationGrant == currentGrant;
    }

    public int getSecurityModel() {
        return 3;
    }

    @Override
    public int compareTo(UsmUser other) {
        return this.securityName.compareTo(other.securityName);
    }

    public Object clone() {
        UsmUser copy = new UsmUser(this.securityName, this.authenticationProtocol, (OctetString)this.authenticationPassphrase, this.privacyProtocol, (OctetString)this.privacyPassphrase, this.localizationEngineID);
        copy.localizationGrant = this.localizationGrant;
        return copy;
    }

    public UsmUser localizeUser(OctetString localizationEngineID, OctetString localizedAuthenticationKey, OctetString localizedPrivacyKey, SecurityProtocols securityProtocols) {
        if (!(this.getLocalizationEngineID() == null || localizationEngineID.equals(this.getLocalizationEngineID()) || localizedAuthenticationKey != null && localizedPrivacyKey != null)) {
            throw new IllegalArgumentException("Localization engine ID cannot be changed");
        }
        if (localizationEngineID == null || localizationEngineID.length() == 0) {
            throw new NullPointerException();
        }
        OctetString newAuthKey = localizedAuthenticationKey == null ? (this.getAuthenticationProtocol() != null && this.getAuthenticationPassphrase() != null ? new SecretOctetString(securityProtocols.passwordToKey(this.getAuthenticationProtocol(), this.getAuthenticationPassphrase(), localizationEngineID.getValue())) : null) : localizedAuthenticationKey;
        OctetString newPrivKey = localizedPrivacyKey == null ? (this.getAuthenticationProtocol() != null && this.getPrivacyProtocol() != null && this.getPrivacyPassphrase() != null ? new SecretOctetString(securityProtocols.passwordToKey(this.getPrivacyProtocol(), this.getAuthenticationProtocol(), this.getPrivacyPassphrase(), localizationEngineID.getValue())) : null) : localizedPrivacyKey;
        return new UsmUser(this.getSecurityName(), this.getAuthenticationProtocol(), newAuthKey, this.getPrivacyProtocol(), newPrivKey, localizationEngineID);
    }

    public LocalizationGrant getLocalizationGrant() {
        return this.isLocalized() ? LocalizationGrant.never : this.localizationGrant;
    }

    public UsmUser setLocalizationGrant(LocalizationGrant localizationGrant) {
        if (this.localizationGrant != localizationGrant && this.isLocalized()) {
            throw new IllegalStateException("Localization grant cannot be changed, because user is already localized");
        }
        this.localizationGrant = localizationGrant;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UsmUser usmUser = (UsmUser)o;
        if (!this.securityName.equals(usmUser.securityName)) {
            return false;
        }
        if (!Objects.equals(this.authenticationPassphrase, usmUser.authenticationPassphrase)) {
            return false;
        }
        if (!Objects.equals(this.privacyPassphrase, usmUser.privacyPassphrase)) {
            return false;
        }
        if (!Objects.equals(this.authenticationProtocol, usmUser.authenticationProtocol)) {
            return false;
        }
        if (!Objects.equals(this.privacyProtocol, usmUser.privacyProtocol)) {
            return false;
        }
        if (!Objects.equals(this.localizationEngineID, usmUser.localizationEngineID)) {
            return false;
        }
        return Objects.equals((Object)this.localizationGrant, (Object)usmUser.localizationGrant);
    }

    public int hashCode() {
        return this.securityName.hashCode();
    }

    public String toString() {
        return "UsmUser[secName=" + String.valueOf(this.securityName) + ",authProtocol=" + String.valueOf(this.authenticationProtocol) + ",authPassphrase=" + String.valueOf(this.authenticationPassphrase) + ",privProtocol=" + String.valueOf(this.privacyProtocol) + ",privPassphrase=" + String.valueOf(this.privacyPassphrase) + ",localizationEngineID=" + String.valueOf(this.getLocalizationEngineID()) + ",allowedLocalization=" + String.valueOf((Object)this.localizationGrant) + "]";
    }

    public static enum LocalizationGrant {
        never,
        outgoing,
        incoming,
        any;

    }
}

