/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.solr;

import org.apache.camel.component.solr.SolrClientHandler;
import org.apache.camel.component.solr.SolrConfiguration;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.impl.HttpSolrClient;

public class SolrClientHandlerHttp
extends SolrClientHandler {
    public SolrClientHandlerHttp(SolrConfiguration solrConfiguration) {
        super(solrConfiguration);
    }

    @Override
    protected SolrClient getSolrClient() {
        HttpSolrClient.Builder builder = new HttpSolrClient.Builder(this.getFirstUrlFromList());
        if (this.solrConfiguration.getConnectionTimeout() != null) {
            builder.withConnectionTimeout(this.solrConfiguration.getConnectionTimeout());
        }
        if (this.solrConfiguration.getSoTimeout() != null) {
            builder.withSocketTimeout(this.solrConfiguration.getSoTimeout());
        }
        if (this.solrConfiguration.getHttpClient() != null) {
            builder.withHttpClient(this.solrConfiguration.getHttpClient());
        }
        if (this.solrConfiguration.getAllowCompression() != null) {
            builder.allowCompression(this.solrConfiguration.getAllowCompression());
        }
        HttpSolrClient httpSolrClient = builder.build();
        if (this.solrConfiguration.getFollowRedirects() != null) {
            httpSolrClient.setFollowRedirects(this.solrConfiguration.getFollowRedirects());
        }
        return httpSolrClient;
    }
}

