/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.solr;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.solr.SolrClientHandler;
import org.apache.camel.component.solr.SolrConfiguration;
import org.apache.camel.component.solr.SolrEndpoint;
import org.apache.camel.component.solr.SolrProducer;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.solr.client.solrj.SolrClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(value="solr,solrCloud,solrs")
public class SolrComponent
extends DefaultComponent {
    private static final Logger LOG = LoggerFactory.getLogger(SolrComponent.class);
    private final Map<String, SolrClientReference> solrClientMap = new HashMap<String, SolrClientReference>();

    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        SolrConfiguration configuration = SolrConfiguration.newInstance(uri, remaining);
        SolrEndpoint endpoint = new SolrEndpoint(uri, this, configuration);
        this.setProperties(endpoint, parameters);
        return endpoint;
    }

    public SolrClient getSolrClient(SolrProducer solrProducer, SolrConfiguration solrConfiguration) {
        SolrClientReference solrClientReference;
        String signature = SolrClientHandler.getSignature(solrConfiguration);
        if (!this.solrClientMap.containsKey(signature)) {
            solrClientReference = new SolrClientReference(SolrClientHandler.getSolrClient(solrConfiguration));
            this.solrClientMap.put(signature, solrClientReference);
        } else {
            solrClientReference = this.solrClientMap.get(signature);
        }
        solrClientReference.registerSolrProducer(solrProducer);
        return solrClientReference.getSolrClient();
    }

    public void closeSolrClient(SolrProducer solrProducer) {
        ArrayList<String> signatureToRemoveList = new ArrayList<String>();
        for (Map.Entry<String, SolrClientReference> entry : this.solrClientMap.entrySet()) {
            SolrClientReference solrClientReference = entry.getValue();
            if (solrClientReference.unRegisterSolrProducer(solrProducer) != 0) continue;
            signatureToRemoveList.add(entry.getKey());
        }
        this.removeFromSolrClientMap(signatureToRemoveList);
    }

    private void removeFromSolrClientMap(Collection<String> signatureToRemoveList) {
        for (String signature : signatureToRemoveList) {
            SolrClientReference solrClientReference = this.solrClientMap.get(signature);
            this.solrClientMap.remove(signature);
            try {
                solrClientReference.getSolrClient().close();
            }
            catch (IOException e) {
                LOG.warn("Error shutting down solr client. This exception is ignored.", (Throwable)e);
            }
        }
    }

    @Override
    protected void doShutdown() throws Exception {
        this.removeFromSolrClientMap(this.solrClientMap.keySet());
    }

    protected static final class SolrClientReference {
        private final SolrClient solrClient;
        private final List<SolrProducer> solrProducerList = new ArrayList<SolrProducer>();

        public SolrClientReference(SolrClient solrClient) {
            this.solrClient = solrClient;
        }

        public SolrClient getSolrClient() {
            return this.solrClient;
        }

        public int unRegisterSolrProducer(SolrProducer solrProducer) {
            this.solrProducerList.remove(solrProducer);
            return this.solrProducerList.size();
        }

        public int registerSolrProducer(SolrProducer solrProducer) {
            this.solrProducerList.add(solrProducer);
            return this.solrProducerList.size();
        }
    }
}

