/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.solr;

import java.util.Optional;
import org.apache.camel.component.solr.SolrClientHandler;
import org.apache.camel.component.solr.SolrEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;
import org.apache.http.client.HttpClient;
import org.apache.solr.client.solrj.SolrClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriParams
public class SolrConfiguration
implements Cloneable {
    private static final Logger LOG = LoggerFactory.getLogger(SolrConfiguration.class);
    private boolean useConcurrentUpdateSolrClient;
    private SolrEndpoint solrEndpoint;
    private SolrScheme solrScheme;
    @UriPath(description="Hostname and port for the Solr server(s). Multiple hosts can be specified, separated with a comma. See the solrClient parameter for more information on the SolrClient used to connect to Solr.")
    @Metadata(required=true)
    private final String url;
    @UriParam(defaultValue="10")
    private int streamingQueueSize = 10;
    @UriParam(defaultValue="2")
    private int streamingThreadCount = 2;
    @UriParam
    private Integer soTimeout;
    @UriParam
    private Integer connectionTimeout;
    @UriParam(label="HttpSolrClient")
    private Boolean followRedirects;
    @UriParam(label="HttpSolrClient")
    private Boolean allowCompression;
    @UriParam(label="CloudSolrClient")
    private String zkHost;
    @UriParam(label="CloudSolrClient")
    private String zkChroot;
    @UriParam(label="CloudSolrClient")
    private String collection;
    @UriParam
    private SolrClient solrClient;
    @UriParam
    private HttpClient httpClient;
    @UriParam
    private String requestHandler;
    @UriParam(label="security", secret=true)
    private String username;
    @UriParam(label="security", secret=true)
    private String password;
    @UriParam(defaultValue="false")
    private boolean autoCommit;
    @Deprecated
    @UriParam
    private Integer maxRetries;
    @Deprecated
    @UriParam
    private Integer defaultMaxConnectionsPerHost;
    @Deprecated
    @UriParam
    private Integer maxTotalConnections;

    public SolrConfiguration(SolrScheme solrScheme, String url, String zkChroot) {
        this.solrScheme = solrScheme;
        this.url = url;
        this.zkChroot = zkChroot;
    }

    public static SolrConfiguration newInstance(String endpointUri, String remaining) {
        SolrScheme solrScheme = SolrScheme.SOLR.getFrom(endpointUri);
        Optional<String> zkChrootOptional = SolrClientHandler.getZkChrootFromUrl(remaining);
        String url = SolrClientHandler.parseHostsFromUrl(remaining, zkChrootOptional);
        SolrConfiguration solrConfiguration = new SolrConfiguration(solrScheme, url, zkChrootOptional.orElse(null));
        SolrClientHandler.getUrlListFrom(solrConfiguration);
        return solrConfiguration;
    }

    public SolrScheme getSolrScheme() {
        return this.solrScheme;
    }

    public void setSolrScheme(SolrScheme solrScheme) {
        this.solrScheme = solrScheme;
    }

    public String getUrl() {
        return this.url;
    }

    public int getStreamingQueueSize() {
        return this.streamingQueueSize;
    }

    public void setStreamingQueueSize(int streamingQueueSize) {
        this.streamingQueueSize = streamingQueueSize;
    }

    public int getStreamingThreadCount() {
        return this.streamingThreadCount;
    }

    public void setStreamingThreadCount(int streamingThreadCount) {
        this.streamingThreadCount = streamingThreadCount;
    }

    public Integer getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(Integer maxRetries) {
        this.maxRetries = maxRetries;
    }

    public Integer getSoTimeout() {
        return this.soTimeout;
    }

    public void setSoTimeout(Integer soTimeout) {
        this.soTimeout = soTimeout;
    }

    public Integer getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(Integer connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public Integer getDefaultMaxConnectionsPerHost() {
        return this.defaultMaxConnectionsPerHost;
    }

    public void setDefaultMaxConnectionsPerHost(Integer defaultMaxConnectionsPerHost) {
        this.defaultMaxConnectionsPerHost = defaultMaxConnectionsPerHost;
    }

    public Integer getMaxTotalConnections() {
        return this.maxTotalConnections;
    }

    public void setMaxTotalConnections(Integer maxTotalConnections) {
        this.maxTotalConnections = maxTotalConnections;
    }

    public Boolean getFollowRedirects() {
        return this.followRedirects;
    }

    public void setFollowRedirects(Boolean followRedirects) {
        this.followRedirects = followRedirects;
    }

    public Boolean getAllowCompression() {
        return this.allowCompression;
    }

    public void setAllowCompression(Boolean allowCompression) {
        this.allowCompression = allowCompression;
    }

    public String getZkHost() {
        return this.zkHost;
    }

    public void setZkHost(String zkHost) {
        Optional<String> zkChrootFromZkHost = SolrClientHandler.getZkChrootFromUrl(zkHost);
        if (zkChrootFromZkHost.isPresent() && this.getZkChroot() == null) {
            this.setZkChroot(zkChrootFromZkHost.get());
        }
        this.zkHost = SolrClientHandler.parseHostsFromUrl(zkHost, zkChrootFromZkHost);
        this.setSolrScheme(SolrScheme.SOLRCLOUD);
    }

    public String getZkChroot() {
        return this.zkChroot;
    }

    public void setZkChroot(String zkChroot) {
        this.zkChroot = zkChroot;
        this.setSolrScheme(SolrScheme.SOLRCLOUD);
    }

    public String getCollection() {
        return this.collection;
    }

    public void setCollection(String collection) {
        this.collection = collection;
    }

    public String getRequestHandler() {
        return this.requestHandler;
    }

    public void setRequestHandler(String requestHandler) {
        this.requestHandler = requestHandler;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isAutoCommit() {
        return this.autoCommit;
    }

    public void setAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    public SolrClient getSolrClient() {
        return this.solrClient;
    }

    public void setSolrClient(SolrClient solrClient) {
        this.solrClient = solrClient;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public boolean getUseConcurrentUpdateSolrClient() {
        return this.useConcurrentUpdateSolrClient;
    }

    void setUseConcurrentUpdateSolrClient(boolean useConcurrentUpdateSolrClient) {
        this.useConcurrentUpdateSolrClient = useConcurrentUpdateSolrClient;
    }

    public SolrEndpoint getSolrEndpoint() {
        return this.solrEndpoint;
    }

    void setSolrEndpoint(SolrEndpoint solrEndpoint) {
        this.solrEndpoint = solrEndpoint;
    }

    public SolrConfiguration deepCopy() {
        try {
            return (SolrConfiguration)this.clone();
        }
        catch (CloneNotSupportedException e) {
            LOG.error(String.format("Could not generate new configuration based on configuration of existing endpoint %s", this.getSolrEndpoint()), (Throwable)e);
            return null;
        }
    }

    public static enum SolrScheme {
        SOLR("solr:", "http://"),
        SOLRS("solrs:", "https://"),
        SOLRCLOUD("solrCloud:", "");

        private final String uri;
        private final String scheme;

        private SolrScheme(String uri, String scheme) {
            this.uri = uri;
            this.scheme = scheme;
        }

        public SolrScheme getFrom(String endpointUri) {
            for (SolrScheme solrScheme : SolrScheme.values()) {
                if (!endpointUri.startsWith(solrScheme.uri)) continue;
                return solrScheme;
            }
            throw new IllegalArgumentException("Invalid endpoint uri");
        }

        public String getUri() {
            return this.uri;
        }

        public String getScheme() {
            return this.scheme;
        }
    }
}

