/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.solr;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Category;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.solr.SolrClientHandler;
import org.apache.camel.component.solr.SolrComponent;
import org.apache.camel.component.solr.SolrConfiguration;
import org.apache.camel.component.solr.SolrConstants;
import org.apache.camel.component.solr.SolrProducer;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultEndpoint;

@UriEndpoint(firstVersion="2.9.0", scheme="solr,solrs,solrCloud", title="Solr", syntax="solr:url", producerOnly=true, category={Category.MONITORING, Category.SEARCH}, headersClass=SolrConstants.class)
public class SolrEndpoint
extends DefaultEndpoint {
    @UriParam
    private SolrConfiguration solrConfiguration;
    private final Map<String, SolrConfiguration> solrConfigurationsMap = new HashMap<String, SolrConfiguration>();

    public SolrEndpoint(String endpointUri, SolrComponent component, SolrConfiguration solrConfiguration) {
        super(endpointUri, component);
        solrConfiguration.setSolrEndpoint(this);
        this.solrConfiguration = solrConfiguration;
        this.solrConfigurationsMap.put("SolrOperation", solrConfiguration);
    }

    public void setZkHost(String zkHost) {
        try {
            String decoded = URLDecoder.decode(zkHost, "UTF-8");
            this.solrConfiguration.setZkHost(decoded);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeCamelException(e);
        }
    }

    public SolrConfiguration getSolrConfiguration() {
        return this.getSolrConfiguration(null);
    }

    public SolrConfiguration getSolrConfiguration(String solrOperation) {
        if (this.solrConfigurationsMap.containsKey(solrOperation)) {
            return this.solrConfigurationsMap.get(solrOperation);
        }
        SolrConfiguration newSolrConfiguration = SolrClientHandler.initializeFor(solrOperation, this.solrConfiguration);
        this.solrConfigurationsMap.put(solrOperation, newSolrConfiguration);
        return newSolrConfiguration;
    }

    public void setRequestHandler(String requestHandler) {
        this.solrConfiguration.setRequestHandler(requestHandler);
    }

    @Override
    public SolrComponent getComponent() {
        return (SolrComponent)super.getComponent();
    }

    @Override
    public Producer createProducer() throws Exception {
        return new SolrProducer(this);
    }

    protected void onProducerShutdown(SolrProducer producer) {
        this.getComponent().closeSolrClient(producer);
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Consumer not supported for Solr endpoint.");
    }
}

