/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.lang.invoke.MethodHandles;
import java.net.CookieHandler;
import java.net.InetSocketAddress;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.net.http.HttpTimeoutException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrClientBase;
import org.apache.solr.client.solrj.impl.HttpSolrClientBuilderBase;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.client.solrj.request.RequestWriter;
import org.apache.solr.client.solrj.util.AsyncListener;
import org.apache.solr.client.solrj.util.Cancellable;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.ObjectReleaseTracker;
import org.apache.solr.common.util.SolrNamedThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpJdkSolrClient
extends HttpSolrClientBase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String USER_AGENT = "Solr[" + MethodHandles.lookup().lookupClass().getName() + "] 1.0";
    protected HttpClient httpClient;
    protected ExecutorService executor;
    private boolean forceHttp11;
    private final boolean shutdownExecutor;
    protected volatile boolean headRequested;
    private boolean headSucceeded;
    private static final Pattern MIME_TYPE_PATTERN = Pattern.compile("[^;]*");
    private static final Pattern CHARSET_PATTERN = Pattern.compile("(?i)^.*charset=(.*)$");

    protected HttpJdkSolrClient(String serverBaseUrl, Builder builder) {
        super(serverBaseUrl, builder);
        HttpClient.Redirect followRedirects = Boolean.TRUE.equals(builder.followRedirects) ? HttpClient.Redirect.NORMAL : HttpClient.Redirect.NEVER;
        HttpClient.Builder b = HttpClient.newBuilder().followRedirects(followRedirects);
        if (builder.sslContext != null) {
            b.sslContext(builder.sslContext);
        }
        if (builder.executor != null) {
            this.executor = builder.executor;
            this.shutdownExecutor = false;
        } else {
            LinkedBlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>(1024);
            this.executor = new ExecutorUtil.MDCAwareThreadPoolExecutor(4, 256, 60L, TimeUnit.SECONDS, queue, new SolrNamedThreadFactory(this.getClass().getSimpleName()));
            this.shutdownExecutor = true;
        }
        b.executor(this.executor);
        if (builder.useHttp1_1) {
            this.forceHttp11 = true;
            b.version(HttpClient.Version.HTTP_1_1);
        }
        if (builder.cookieHandler != null) {
            b.cookieHandler(builder.cookieHandler);
        }
        if (builder.proxyHost != null) {
            if (builder.proxyIsSocks4) {
                log.warn("Socks4 is likely not supported by this client.  See https://bugs.openjdk.org/browse/JDK-8214516");
            }
            b.proxy(ProxySelector.of(new InetSocketAddress(builder.proxyHost, builder.proxyPort)));
        }
        this.httpClient = b.build();
        this.updateDefaultMimeTypeForParser();
        assert (ObjectReleaseTracker.track(this));
    }

    @Override
    public Cancellable asyncRequest(SolrRequest<?> solrRequest, String collection, AsyncListener<NamedList<Object>> asyncListener) {
        asyncListener.onStart();
        CompletionStage cf = this.requestAsync(solrRequest, collection).whenComplete((nl, t) -> {
            if (t != null) {
                asyncListener.onFailure((Throwable)t);
            } else {
                asyncListener.onSuccess((NamedList<Object>)nl);
            }
        });
        return new HttpSolrClientCancellable((CompletableFuture<NamedList<Object>>)cf);
    }

    @Override
    public CompletableFuture<NamedList<Object>> requestAsync(SolrRequest<?> solrRequest, String collection) {
        try {
            PreparedRequest pReq = this.prepareRequest(solrRequest, collection);
            return this.httpClient.sendAsync(pReq.reqb.build(), HttpResponse.BodyHandlers.ofInputStream()).thenApply(httpResponse -> {
                try {
                    return this.processErrorsAndResponse(solrRequest, pReq.parserToUse, (HttpResponse<InputStream>)httpResponse, pReq.url);
                }
                catch (SolrServerException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (Exception e) {
            CompletableFuture<NamedList<Object>> cf = new CompletableFuture<NamedList<Object>>();
            cf.completeExceptionally(e);
            return cf;
        }
    }

    @Override
    public NamedList<Object> request(SolrRequest<?> solrRequest, String collection) throws SolrServerException, IOException {
        PreparedRequest pReq = this.prepareRequest(solrRequest, collection);
        HttpResponse<InputStream> response = null;
        try {
            response = this.httpClient.send(pReq.reqb.build(), HttpResponse.BodyHandlers.ofInputStream());
            NamedList<Object> namedList = this.processErrorsAndResponse(solrRequest, pReq.parserToUse, response, pReq.url);
            return namedList;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (HttpTimeoutException e) {
            throw new SolrServerException("Timeout occurred while waiting response from server at: " + pReq.url, e);
        }
        catch (SolrException se) {
            throw se;
        }
        catch (RuntimeException re) {
            throw new SolrServerException(re);
        }
        finally {
            if (pReq.contentWritingFuture != null) {
                pReq.contentWritingFuture.cancel(true);
            }
            if (!this.wantStream(pReq.parserToUse)) {
                try {
                    response.body().close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private PreparedRequest prepareRequest(SolrRequest<?> solrRequest, String collection) throws SolrServerException, IOException {
        this.checkClosed();
        if (ClientUtils.shouldApplyDefaultCollection(collection, solrRequest)) {
            collection = this.defaultCollection;
        }
        String url = this.getRequestPath(solrRequest, collection);
        ResponseParser parserToUse = this.responseParser(solrRequest);
        ModifiableSolrParams queryParams = this.initalizeSolrParams(solrRequest, parserToUse);
        HttpRequest.Builder reqb = HttpRequest.newBuilder();
        PreparedRequest pReq = null;
        try {
            switch (solrRequest.getMethod()) {
                case GET: {
                    pReq = this.prepareGet(url, reqb, solrRequest, queryParams);
                    break;
                }
                case POST: 
                case PUT: {
                    pReq = this.preparePutOrPost(url, solrRequest.getMethod(), reqb, solrRequest, queryParams);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported method: " + solrRequest.getMethod());
                }
            }
        }
        catch (RuntimeException | URISyntaxException re) {
            throw new SolrServerException(re);
        }
        pReq.parserToUse = parserToUse;
        pReq.url = url;
        return pReq;
    }

    private PreparedRequest prepareGet(String url, HttpRequest.Builder reqb, SolrRequest<?> solrRequest, ModifiableSolrParams queryParams) throws IOException, URISyntaxException {
        this.validateGetRequest(solrRequest);
        reqb.GET();
        this.decorateRequest(reqb, solrRequest);
        reqb.uri(new URI(url + queryParams.toQueryString()));
        return new PreparedRequest(reqb, null);
    }

    private PreparedRequest preparePutOrPost(String url, SolrRequest.METHOD method, HttpRequest.Builder reqb, SolrRequest<?> solrRequest, ModifiableSolrParams queryParams) throws IOException, URISyntaxException {
        HttpRequest.BodyPublisher bodyPublisher;
        RequestWriter.ContentWriter contentWriter = this.requestWriter.getContentWriter(solrRequest);
        Collection<ContentStream> streams = contentWriter == null ? this.requestWriter.getContentStreams(solrRequest) : null;
        String contentType = "application/x-www-form-urlencoded";
        if (contentWriter != null && contentWriter.getContentType() != null) {
            contentType = contentWriter.getContentType();
        }
        reqb.header("Content-Type", contentType);
        if (this.isMultipart(streams)) {
            throw new UnsupportedOperationException("This client does not support multipart.");
        }
        Future<?> contentWritingFuture = null;
        if (contentWriter != null) {
            boolean success = this.maybeTryHeadRequest(url);
            if (!success) {
                reqb.version(HttpClient.Version.HTTP_1_1);
            }
            PipedOutputStream source = new PipedOutputStream();
            PipedInputStream sink = new PipedInputStream(source);
            bodyPublisher = HttpRequest.BodyPublishers.ofInputStream(() -> sink);
            contentWritingFuture = this.executor.submit(() -> {
                try (PipedOutputStream pipedOutputStream = source;){
                    contentWriter.write(source);
                }
                catch (Exception e) {
                    log.error("Cannot write Content Stream", (Throwable)e);
                }
            });
        } else if (streams != null && streams.size() == 1) {
            boolean success = this.maybeTryHeadRequest(url);
            if (!success) {
                reqb.version(HttpClient.Version.HTTP_1_1);
            }
            InputStream is = streams.iterator().next().getStream();
            bodyPublisher = HttpRequest.BodyPublishers.ofInputStream(() -> is);
        } else if (queryParams != null && this.urlParamNames != null) {
            ModifiableSolrParams requestParams = queryParams;
            queryParams = this.calculateQueryParams(this.urlParamNames, requestParams);
            queryParams.add(this.calculateQueryParams(solrRequest.getQueryParams(), requestParams));
            bodyPublisher = HttpRequest.BodyPublishers.ofString(requestParams.toQueryString().substring(1));
        } else {
            bodyPublisher = HttpRequest.BodyPublishers.noBody();
        }
        this.decorateRequest(reqb, solrRequest);
        if (method == SolrRequest.METHOD.PUT) {
            reqb.method("PUT", bodyPublisher);
        } else {
            reqb.method("POST", bodyPublisher);
        }
        URI uriWithQueryParams = new URI(url + queryParams.toQueryString());
        reqb.uri(uriWithQueryParams);
        return new PreparedRequest(reqb, contentWritingFuture);
    }

    protected boolean maybeTryHeadRequest(String url) {
        if (this.forceHttp11 || url == null || url.toLowerCase(Locale.ROOT).startsWith("https://")) {
            return true;
        }
        return this.maybeTryHeadRequestSync(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean maybeTryHeadRequestSync(String url) {
        URI uriNoQueryParams;
        if (this.headRequested) {
            return this.headSucceeded;
        }
        try {
            uriNoQueryParams = new URI(url);
        }
        catch (URISyntaxException e) {
            return false;
        }
        HttpRequest.Builder headReqB = HttpRequest.newBuilder(uriNoQueryParams).method("HEAD", HttpRequest.BodyPublishers.noBody());
        this.decorateRequest(headReqB, new QueryRequest());
        try {
            this.httpClient.send(headReqB.build(), HttpResponse.BodyHandlers.discarding());
            this.headSucceeded = true;
        }
        catch (IOException ioe) {
            log.warn("Could not issue HEAD request to {} ", (Object)url, (Object)ioe);
            this.headSucceeded = false;
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            this.headSucceeded = false;
        }
        finally {
            this.headRequested = true;
            if (!this.headSucceeded) {
                log.info("All unencrypted POST requests with a chunked body will use http/1.1");
            }
        }
        return this.headSucceeded;
    }

    private void decorateRequest(HttpRequest.Builder reqb, SolrRequest<?> solrRequest) {
        if (this.requestTimeoutMillis > 0L) {
            reqb.timeout(Duration.of(this.requestTimeoutMillis, ChronoUnit.MILLIS));
        } else if (this.idleTimeoutMillis > 0L) {
            reqb.timeout(Duration.of(this.idleTimeoutMillis, ChronoUnit.MILLIS));
        }
        reqb.header("User-Agent", USER_AGENT);
        this.setBasicAuthHeader(solrRequest, reqb);
        Map<String, String> headers = solrRequest.getHeaders();
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                reqb.header(entry.getKey(), entry.getValue());
            }
        }
    }

    private void setBasicAuthHeader(SolrRequest<?> solrRequest, HttpRequest.Builder reqb) {
        if (solrRequest.getBasicAuthUser() != null && solrRequest.getBasicAuthPassword() != null) {
            String encoded = HttpJdkSolrClient.basicAuthCredentialsToAuthorizationString(solrRequest.getBasicAuthUser(), solrRequest.getBasicAuthPassword());
            reqb.header("Authorization", encoded);
        } else if (this.basicAuthAuthorizationStr != null) {
            reqb.header("Authorization", this.basicAuthAuthorizationStr);
        }
    }

    private String contentTypeToMimeType(String contentType) {
        Matcher mimeTypeMatcher = MIME_TYPE_PATTERN.matcher(contentType);
        return mimeTypeMatcher.find() ? mimeTypeMatcher.group() : null;
    }

    protected String contentTypeToEncoding(String contentType) {
        Matcher encodingMatcher = CHARSET_PATTERN.matcher(contentType);
        return encodingMatcher.find() ? encodingMatcher.group(1) : null;
    }

    private NamedList<Object> processErrorsAndResponse(SolrRequest<?> solrRequest, ResponseParser parser, HttpResponse<InputStream> resp, String url) throws SolrServerException {
        String contentType = resp.headers().firstValue("Content-Type").orElse(null);
        contentType = contentType == null ? "" : contentType;
        String mimeType = this.contentTypeToMimeType(contentType);
        String encoding = this.contentTypeToEncoding(contentType);
        String method = resp.request() == null ? null : resp.request().method();
        int status = resp.statusCode();
        String reason = "" + status;
        InputStream is = resp.body();
        return this.processErrorsAndResponse(status, reason, method, parser, is, mimeType, encoding, this.isV2ApiRequest(solrRequest), url);
    }

    @Override
    public void close() throws IOException {
        if (this.httpClient instanceof AutoCloseable) {
            try {
                ((AutoCloseable)this.httpClient).close();
            }
            catch (Exception e) {
                log.warn("Could not close the http client.", (Throwable)e);
            }
        }
        this.httpClient = null;
        if (this.shutdownExecutor) {
            ExecutorUtil.shutdownAndAwaitTermination(this.executor);
        }
        this.executor = null;
        assert (ObjectReleaseTracker.release(this));
    }

    private void checkClosed() {
        if (this.httpClient == null) {
            throw new IllegalStateException("This is closed and cannot be reused.");
        }
    }

    @Override
    protected boolean isFollowRedirects() {
        return this.httpClient.followRedirects() != HttpClient.Redirect.NEVER;
    }

    @Override
    protected boolean processorAcceptsMimeType(Collection<String> processorSupportedContentTypes, String mimeType) {
        return processorSupportedContentTypes.stream().map(this::contentTypeToMimeType).filter(Objects::nonNull).map(String::trim).anyMatch(mimeType::equalsIgnoreCase);
    }

    @Override
    protected void updateDefaultMimeTypeForParser() {
        this.defaultParserMimeTypes = this.parser.getContentTypes().stream().map(this::contentTypeToMimeType).filter(Objects::nonNull).map(s -> s.toLowerCase(Locale.ROOT).trim()).collect(Collectors.toSet());
    }

    @Override
    protected String allProcessorSupportedContentTypesCommaDelimited(Collection<String> processorSupportedContentTypes) {
        return processorSupportedContentTypes.stream().map(this::contentTypeToMimeType).filter(Objects::nonNull).map(s -> s.toLowerCase(Locale.ROOT).trim()).collect(Collectors.joining(", "));
    }

    public static class Builder
    extends HttpSolrClientBuilderBase<Builder, HttpJdkSolrClient> {
        private SSLContext sslContext;
        private CookieHandler cookieHandler;

        public Builder() {
        }

        public Builder(String baseSolrUrl) {
            this.baseSolrUrl = baseSolrUrl;
        }

        @Override
        public HttpJdkSolrClient build() {
            if (this.idleTimeoutMillis == null || this.idleTimeoutMillis <= 0L) {
                this.idleTimeoutMillis = 600000L;
            }
            if (this.connectionTimeoutMillis == null) {
                this.connectionTimeoutMillis = 60000L;
            }
            return new HttpJdkSolrClient(this.baseSolrUrl, this);
        }

        public Builder withSSLContext(SSLContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        public Builder withCookieHandler(CookieHandler cookieHandler) {
            this.cookieHandler = cookieHandler;
            return this;
        }
    }

    protected static class HttpSolrClientCancellable
    implements Cancellable {
        private final CompletableFuture<NamedList<Object>> response;

        protected HttpSolrClientCancellable(CompletableFuture<NamedList<Object>> response) {
            this.response = response;
        }

        @Override
        public void cancel() {
            this.response.cancel(true);
        }

        protected CompletableFuture<NamedList<Object>> getResponse() {
            return this.response;
        }
    }

    private static class PreparedRequest {
        Future<?> contentWritingFuture;
        HttpRequest.Builder reqb;
        ResponseParser parserToUse;
        String url;

        PreparedRequest(HttpRequest.Builder reqb, Future<?> contentWritingFuture) {
            this.reqb = reqb;
            this.contentWritingFuture = contentWritingFuture;
        }
    }
}

