/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.analysis.polynomials.PolynomialFunction;
import org.apache.commons.math3.fitting.PolynomialCurveFitter;
import org.apache.commons.math3.fitting.WeightedObservedPoints;
import org.apache.solr.client.solrj.io.eval.ManyValueWorker;
import org.apache.solr.client.solrj.io.eval.RecursiveNumericEvaluator;
import org.apache.solr.client.solrj.io.eval.VectorFunction;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class PolyFitEvaluator
extends RecursiveNumericEvaluator
implements ManyValueWorker {
    protected static final long serialVersionUID = 1L;

    public PolyFitEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
    }

    @Override
    public Object doWork(Object ... objects) throws IOException {
        if (objects.length > 3) {
            throw new IOException("polyfit function takes a maximum of 3 arguments.");
        }
        Object first = objects[0];
        double[] x = null;
        double[] y = null;
        int degree = 3;
        if (objects.length == 1) {
            y = ((List)first).stream().mapToDouble(value -> ((Number)value).doubleValue()).toArray();
            x = new double[y.length];
            for (int i = 0; i < y.length; ++i) {
                x[i] = i;
            }
        } else if (objects.length == 3) {
            Object second = objects[1];
            x = ((List)first).stream().mapToDouble(value -> ((Number)value).doubleValue()).toArray();
            y = ((List)second).stream().mapToDouble(value -> ((Number)value).doubleValue()).toArray();
            degree = ((Number)objects[2]).intValue();
        } else if (objects.length == 2) {
            if (objects[1] instanceof List) {
                Object second = objects[1];
                x = ((List)first).stream().mapToDouble(value -> ((Number)value).doubleValue()).toArray();
                y = ((List)second).stream().mapToDouble(value -> ((Number)value).doubleValue()).toArray();
            } else {
                y = ((List)first).stream().mapToDouble(value -> ((Number)value).doubleValue()).toArray();
                x = new double[y.length];
                for (int i = 0; i < y.length; ++i) {
                    x[i] = i;
                }
                degree = ((Number)objects[1]).intValue();
            }
        }
        PolynomialCurveFitter curveFitter = PolynomialCurveFitter.create(degree);
        WeightedObservedPoints points = new WeightedObservedPoints();
        for (int i = 0; i < x.length; ++i) {
            points.add(x[i], y[i]);
        }
        double[] coef = curveFitter.fit(points.toList());
        PolynomialFunction pf = new PolynomialFunction(coef);
        ArrayList<Double> list = new ArrayList<Double>();
        for (double xvalue : x) {
            double yvalue = pf.value(xvalue);
            list.add(yvalue);
        }
        VectorFunction vec = new VectorFunction((Object)pf, list);
        vec.addToContext("x", x);
        vec.addToContext("y", y);
        return vec;
    }
}

