/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.math3.distribution.IntegerDistribution;
import org.apache.commons.math3.distribution.RealDistribution;
import org.apache.commons.math3.ml.clustering.Cluster;
import org.apache.commons.math3.random.EmpiricalDistribution;
import org.apache.commons.math3.stat.Frequency;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.apache.commons.math3.util.Precision;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.eval.DbscanEvaluator;
import org.apache.solr.client.solrj.io.eval.KmeansEvaluator;
import org.apache.solr.client.solrj.io.eval.Matrix;
import org.apache.solr.client.solrj.io.eval.StreamEvaluator;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExplanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionNamedParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class ZplotStream
extends TupleStream
implements Expressible {
    private static final long serialVersionUID = 1L;
    private StreamContext streamContext;
    private Map<String, Object> letParams = new LinkedHashMap<String, Object>();
    private Iterator<Tuple> out;

    public ZplotStream(StreamExpression expression, StreamFactory factory) throws IOException {
        List<StreamExpressionNamedParameter> namedParams = factory.getNamedOperands(expression);
        for (StreamExpressionNamedParameter np : namedParams) {
            String name = np.getName();
            StreamExpressionParameter param = np.getParameter();
            if (param instanceof StreamExpressionValue) {
                String paramValue = ((StreamExpressionValue)param).getValue();
                this.letParams.put(name, factory.constructPrimitiveObject(paramValue));
                continue;
            }
            if (!factory.isEvaluator((StreamExpression)param)) continue;
            StreamEvaluator evaluator = factory.constructEvaluator((StreamExpression)param);
            this.letParams.put(name, evaluator);
        }
    }

    @Override
    public StreamExpression toExpression(StreamFactory factory) throws IOException {
        return this.toExpression(factory, true);
    }

    private StreamExpression toExpression(StreamFactory factory, boolean includeStreams) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        return expression;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        StreamExplanation explanation = new StreamExplanation(this.getStreamNodeId().toString());
        explanation.setFunctionName(factory.getFunctionName(this.getClass()));
        explanation.setImplementingClass(this.getClass().getName());
        explanation.setExpressionType("stream-decorator");
        explanation.setExpression(this.toExpression(factory, false).toString());
        return explanation;
    }

    @Override
    public void setStreamContext(StreamContext context) {
        this.streamContext = context;
    }

    @Override
    public List<TupleStream> children() {
        ArrayList<TupleStream> l = new ArrayList<TupleStream>();
        return l;
    }

    @Override
    public Tuple read() throws IOException {
        if (this.out.hasNext()) {
            return this.out.next();
        }
        return Tuple.EOF();
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void open() throws IOException {
        Object rowLabel;
        List<String> colLabels;
        List<String> rowLabels;
        Matrix m;
        Object o;
        Map<String, Object> lets = this.streamContext.getLets();
        Set<Map.Entry<String, Object>> entries = this.letParams.entrySet();
        HashMap<String, Object> evaluated = new HashMap<String, Object>();
        int numTuples = -1;
        int columns = 0;
        boolean table = false;
        boolean distribution = false;
        boolean clusters = false;
        boolean heat = false;
        for (Map.Entry<String, Object> entry : entries) {
            ++columns;
            String name = entry.getKey();
            if (name.equals("table")) {
                table = true;
            } else if (name.equals("dist")) {
                distribution = true;
            } else if (name.equals("clusters")) {
                clusters = true;
            } else if (name.equals("heat")) {
                heat = true;
            }
            Iterator o2 = entry.getValue();
            if (o2 instanceof StreamEvaluator) {
                Tuple eTuple = new Tuple(lets);
                StreamEvaluator streamEvaluator = (StreamEvaluator)((Object)o2);
                streamEvaluator.setStreamContext(this.streamContext);
                Object eo = streamEvaluator.evaluate(eTuple);
                if (eo instanceof List) {
                    List l2 = (List)eo;
                    if (numTuples == -1) {
                        numTuples = l2.size();
                    } else if (l2.size() != numTuples) {
                        throw new IOException("All lists provided to the zplot function must be the same length.");
                    }
                    evaluated.put(name, l2);
                    continue;
                }
                if (eo instanceof Tuple) {
                    evaluated.put(name, eo);
                    continue;
                }
                evaluated.put(name, eo);
                continue;
            }
            Object eval = lets.get(o2);
            if (eval instanceof List) {
                List list = (List)eval;
                if (numTuples == -1) {
                    numTuples = list.size();
                } else if (list.size() != numTuples) {
                    throw new IOException("All lists provided to the zplot function must be the same length.");
                }
                evaluated.put(name, list);
                continue;
            }
            if (eval instanceof Tuple) {
                evaluated.put(name, eval);
                continue;
            }
            if (!(eval instanceof Matrix)) continue;
            evaluated.put(name, eval);
        }
        if (columns > 1 && (table || distribution)) {
            throw new IOException("If the table or dist parameter is set there can only be one parameter.");
        }
        ArrayList<Tuple> outTuples = new ArrayList<Tuple>();
        if (!(table || distribution || clusters || heat)) {
            for (int i = 0; i < numTuples; ++i) {
                Tuple tuple = new Tuple();
                for (Map.Entry entry : evaluated.entrySet()) {
                    List list = (List)entry.getValue();
                    tuple.put((String)entry.getKey(), list.get(i));
                }
                outTuples.add(tuple);
            }
            if (((Tuple)outTuples.get(0)).getFields().containsKey("y") && !((Tuple)outTuples.get(0)).getFields().containsKey("x")) {
                int x = 0;
                for (Tuple tuple : outTuples) {
                    tuple.put("x", x++);
                }
            }
        } else if (clusters) {
            List points;
            List<Cluster> cs;
            Tuple ct;
            o = evaluated.get("clusters");
            if (o instanceof KmeansEvaluator.ClusterTuple) {
                ct = (KmeansEvaluator.ClusterTuple)o;
                cs = ((KmeansEvaluator.ClusterTuple)ct).getClusters();
                int clusterNum = 0;
                for (Cluster c : cs) {
                    ++clusterNum;
                    points = c.getPoints();
                    for (KmeansEvaluator.ClusterPoint p : points) {
                        Tuple tuple = new Tuple();
                        tuple.put("x", p.getPoint()[0]);
                        tuple.put("y", p.getPoint()[1]);
                        tuple.put("cluster", "cluster" + clusterNum);
                        outTuples.add(tuple);
                    }
                }
            } else if (o instanceof DbscanEvaluator.ClusterTuple) {
                ct = (DbscanEvaluator.ClusterTuple)o;
                cs = ((DbscanEvaluator.ClusterTuple)ct).getClusters();
                int clusterNum = 0;
                for (Cluster c : cs) {
                    ++clusterNum;
                    points = c.getPoints();
                    for (DbscanEvaluator.ClusterPoint p : points) {
                        Tuple tuple = new Tuple();
                        tuple.put("x", p.getPoint()[0]);
                        tuple.put("y", p.getPoint()[1]);
                        tuple.put("cluster", "cluster" + clusterNum);
                        outTuples.add(tuple);
                    }
                }
            }
        } else if (distribution) {
            List list;
            o = evaluated.get("dist");
            if (o instanceof RealDistribution) {
                int i;
                RealDistribution realDistribution = (RealDistribution)o;
                List<SummaryStatistics> binStats = null;
                if (realDistribution instanceof EmpiricalDistribution) {
                    EmpiricalDistribution empiricalDistribution = (EmpiricalDistribution)realDistribution;
                    binStats = empiricalDistribution.getBinStats();
                } else {
                    double[] samples = realDistribution.sample(500000);
                    EmpiricalDistribution empiricalDistribution = new EmpiricalDistribution(32);
                    empiricalDistribution.load(samples);
                    binStats = empiricalDistribution.getBinStats();
                }
                double[] x = new double[binStats.size()];
                double[] dArray = new double[binStats.size()];
                for (i = 0; i < binStats.size(); ++i) {
                    x[i] = binStats.get(i).getMean();
                    dArray[i] = realDistribution.density(x[i]);
                }
                for (i = 0; i < x.length; ++i) {
                    Tuple tuple = new Tuple();
                    if (Double.isNaN(x[i])) continue;
                    tuple.put("x", Precision.round(x[i], 2));
                    if (dArray[i] == Double.NEGATIVE_INFINITY || dArray[i] == Double.POSITIVE_INFINITY) {
                        tuple.put("y", 0);
                    } else {
                        tuple.put("y", dArray[i]);
                    }
                    outTuples.add(tuple);
                }
            } else if (o instanceof IntegerDistribution) {
                int i;
                IntegerDistribution integerDistribution = (IntegerDistribution)o;
                int[] samples = integerDistribution.sample(50000);
                Frequency frequency = new Frequency();
                for (int i2 : samples) {
                    frequency.addValue(i2);
                }
                Iterator<Comparable<?>> iterator = frequency.valuesIterator();
                ArrayList<Long> values = new ArrayList<Long>();
                while (iterator.hasNext()) {
                    values.add((Long)iterator.next());
                }
                int[] x = new int[values.size()];
                double[] y = new double[values.size()];
                for (i = 0; i < values.size(); ++i) {
                    x[i] = ((Long)values.get(i)).intValue();
                    y[i] = integerDistribution.probability(x[i]);
                }
                for (i = 0; i < x.length; ++i) {
                    Tuple tuple = new Tuple();
                    tuple.put("x", x[i]);
                    tuple.put("y", y[i]);
                    outTuples.add(tuple);
                }
            } else if (o instanceof List && (list = (List)o).get(0) instanceof Tuple) {
                Tuple outtuple;
                List tlist = (List)o;
                Tuple tuple = (Tuple)tlist.get(0);
                if (tuple.getFields().containsKey("N")) {
                    for (Tuple t : tlist) {
                        outtuple = new Tuple();
                        outtuple.put("x", Precision.round((Double)t.get("mean"), 2));
                        outtuple.put("y", t.get("prob"));
                        outTuples.add(outtuple);
                    }
                } else if (tuple.getFields().containsKey("count")) {
                    for (Tuple t : tlist) {
                        outtuple = new Tuple();
                        outtuple.put("x", t.get("value"));
                        outtuple.put("y", t.get("pct"));
                        outTuples.add(outtuple);
                    }
                }
            }
        } else if (table) {
            o = evaluated.get("table");
            if (o instanceof Matrix) {
                m = (Matrix)o;
                rowLabels = m.getRowLabels();
                colLabels = m.getColumnLabels();
                double[][] dArray = m.getData();
                for (int i = 0; i < dArray.length; ++i) {
                    rowLabel = null;
                    rowLabel = rowLabels != null ? rowLabels.get(i) : Integer.toString(i);
                    Tuple tuple = new Tuple();
                    tuple.put("rowLabel", rowLabel);
                    double[] row = dArray[i];
                    for (int j = 0; j < row.length; ++j) {
                        Object colLabel = null;
                        colLabel = colLabels != null ? colLabels.get(j) : "col" + Integer.toString(j);
                        tuple.put((String)colLabel, dArray[i][j]);
                    }
                    outTuples.add(tuple);
                }
            }
        } else if (heat && (o = evaluated.get("heat")) instanceof Matrix) {
            m = (Matrix)o;
            rowLabels = m.getRowLabels();
            colLabels = m.getColumnLabels();
            double[][] dArray = m.getData();
            for (int i = 0; i < dArray.length; ++i) {
                rowLabel = null;
                rowLabel = rowLabels != null ? rowLabels.get(i) : "row" + ZplotStream.pad(Integer.toString(i), dArray.length);
                double[] row = dArray[i];
                for (int j = 0; j < row.length; ++j) {
                    Tuple tuple = new Tuple();
                    tuple.put("y", rowLabel);
                    Object colLabel = null;
                    colLabel = colLabels != null ? colLabels.get(j) : "col" + ZplotStream.pad(Integer.toString(j), row.length);
                    tuple.put("x", colLabel);
                    tuple.put("z", dArray[i][j]);
                    outTuples.add(tuple);
                }
            }
        }
        this.out = outTuples.iterator();
    }

    public static String pad(String v, int length) {
        if (length < 11) {
            return v;
        }
        if (length < 101) {
            return ZplotStream.prepend(v, 2);
        }
        if (length < 1001) {
            return ZplotStream.prepend(v, 3);
        }
        if (length < 10001) {
            return ZplotStream.prepend(v, 4);
        }
        return ZplotStream.prepend(v, 5);
    }

    private static String prepend(String v, int length) {
        while (((String)v).length() < length) {
            v = "0" + (String)v;
        }
        return v;
    }

    @Override
    public StreamComparator getStreamSort() {
        return null;
    }

    @Override
    public int getCost() {
        return 0;
    }
}

