/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.splunkhec;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.splunkhec.SplunkHECEndpoint;
import org.apache.camel.support.DefaultProducer;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.http.io.entity.EntityTemplate;
import org.apache.hc.core5.http.message.StatusLine;
import org.apache.hc.core5.ssl.SSLContextBuilder;

public class SplunkHECProducer
extends DefaultProducer {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final SplunkHECEndpoint endpoint;
    private CloseableHttpClient httpClient;

    public SplunkHECProducer(SplunkHECEndpoint endpoint) {
        super(endpoint);
        this.endpoint = endpoint;
    }

    @Override
    protected void doStart() throws Exception {
        PoolingHttpClientConnectionManager connManager;
        super.doStart();
        HttpClientBuilder builder = HttpClients.custom().setUserAgent("Camel Splunk HEC/" + this.getEndpoint().getCamelContext().getVersion());
        if (this.endpoint.getConfiguration().isSkipTlsVerify()) {
            SSLContextBuilder sslbuilder = new SSLContextBuilder();
            sslbuilder.loadTrustMaterial(null, (chain, authType) -> true);
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslbuilder.build(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            RegistryBuilder<SSLConnectionSocketFactory> registryBuilder = RegistryBuilder.create();
            registryBuilder.register("https", sslsf);
            connManager = new PoolingHttpClientConnectionManager(registryBuilder.build());
        } else {
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(this.endpoint.provideSSLContext(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            RegistryBuilder<SSLConnectionSocketFactory> registryBuilder = RegistryBuilder.create();
            registryBuilder.register("https", sslsf);
            connManager = new PoolingHttpClientConnectionManager(registryBuilder.build());
        }
        connManager.setMaxTotal(10);
        builder.setConnectionManager(connManager);
        this.httpClient = builder.build();
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        Map<String, Object> payload = this.createPayload(exchange.getIn());
        HttpPost httppost = new HttpPost((this.endpoint.getConfiguration().isHttps() ? "https" : "http") + "://" + this.endpoint.getSplunkURL() + this.endpoint.getConfiguration().getSplunkEndpoint());
        httppost.addHeader("Authorization", " Splunk " + this.endpoint.getConfiguration().getToken());
        EntityTemplate entityTemplate = new EntityTemplate(-1L, ContentType.APPLICATION_JSON, null, outputStream -> MAPPER.writer().writeValue((OutputStream)outputStream, (Object)payload));
        httppost.setEntity(entityTemplate);
        this.httpClient.execute((ClassicHttpRequest)httppost, response -> {
            if (response.getCode() != 200) {
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                response.getEntity().writeTo(output);
                throw new RuntimeException(String.valueOf(new StatusLine(response)) + "\n" + output.toString(StandardCharsets.UTF_8));
            }
            return null;
        });
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        if (this.httpClient != null) {
            this.httpClient.close();
        }
    }

    Map<String, Object> createPayload(Message message) {
        Object body = message.getBody();
        HashMap<String, Object> payload = new HashMap<String, Object>();
        this.buildPayload(message, payload);
        if (this.endpoint.getConfiguration().isBodyOnly()) {
            payload.put("event", body);
        } else if (this.endpoint.getConfiguration().isHeadersOnly()) {
            payload.put("event", message.getHeaders());
        } else {
            HashMap<String, Object> eventPayload = new HashMap<String, Object>();
            eventPayload.put("body", body);
            eventPayload.put("headers", message.getHeaders());
            payload.put("event", eventPayload);
        }
        return payload;
    }

    private void buildPayload(Message message, Map<String, Object> payload) {
        Long time;
        if (this.endpoint.getConfiguration().getSourceType() != null) {
            payload.put("sourcetype", this.endpoint.getConfiguration().getSourceType());
        }
        if (this.endpoint.getConfiguration().getSource() != null) {
            payload.put("source", this.endpoint.getConfiguration().getSource());
        }
        if (this.endpoint.getConfiguration().getIndex() != null) {
            payload.put("index", this.endpoint.getConfiguration().getIndex());
        }
        if (this.endpoint.getConfiguration().getHost() != null) {
            payload.put("host", this.endpoint.getConfiguration().getHost());
        }
        if ((time = message.getHeader("CamelSplunkHECIndexTime", this.endpoint.getConfiguration().getTime(), Long.class)) != null) {
            payload.put("time", time);
        }
    }
}

