/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.spring.batch.support;

import org.apache.camel.ProducerTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.item.Chunk;
import org.springframework.batch.item.ItemWriter;

public class CamelItemWriter<I>
implements ItemWriter<I> {
    private static final Logger LOG = LoggerFactory.getLogger(CamelItemWriter.class);
    private final ProducerTemplate template;
    private final String endpointUri;

    public CamelItemWriter(ProducerTemplate template, String endpointUri) {
        this.template = template;
        this.endpointUri = endpointUri;
    }

    @Override
    public void write(Chunk<? extends I> chunk) throws Exception {
        for (Object item : chunk) {
            LOG.debug("writing item [{}]...", item);
            this.template.sendBody(this.endpointUri, item);
            LOG.debug("wrote item");
        }
    }
}

