/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.configuration.annotation;

import org.springframework.batch.core.configuration.JobRegistry;
import org.springframework.batch.core.configuration.support.ApplicationContextFactory;
import org.springframework.batch.core.configuration.support.AutomaticJobRegistrar;
import org.springframework.batch.core.configuration.support.DefaultJobLoader;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;

class AutomaticJobRegistrarBeanPostProcessor
implements BeanFactoryPostProcessor,
BeanPostProcessor {
    private ConfigurableListableBeanFactory beanFactory;

    AutomaticJobRegistrarBeanPostProcessor() {
    }

    @Override
    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    @Override
    public Object postProcessAfterInitialization(Object bean2, String beanName) throws BeansException {
        if (bean2 instanceof AutomaticJobRegistrar) {
            AutomaticJobRegistrar automaticJobRegistrar = (AutomaticJobRegistrar)bean2;
            automaticJobRegistrar.setJobLoader(new DefaultJobLoader(this.beanFactory.getBean(JobRegistry.class)));
            for (ApplicationContextFactory factory : this.beanFactory.getBeansOfType(ApplicationContextFactory.class).values()) {
                automaticJobRegistrar.addApplicationContextFactory(factory);
            }
            return automaticJobRegistrar;
        }
        return bean2;
    }
}

