/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.configuration.annotation;

import io.micrometer.observation.ObservationRegistry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.job.AbstractJob;
import org.springframework.batch.core.step.AbstractStep;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;

public class BatchObservabilityBeanPostProcessor
implements BeanFactoryPostProcessor,
BeanPostProcessor {
    private static final Log LOGGER = LogFactory.getLog(BatchObservabilityBeanPostProcessor.class);
    private ConfigurableListableBeanFactory beanFactory;

    @Override
    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    @Override
    public Object postProcessAfterInitialization(Object bean2, String beanName) throws BeansException {
        try {
            if (bean2 instanceof AbstractJob || bean2 instanceof AbstractStep) {
                ObservationRegistry observationRegistry = this.beanFactory.getBean(ObservationRegistry.class);
                if (bean2 instanceof AbstractJob) {
                    ((AbstractJob)bean2).setObservationRegistry(observationRegistry);
                }
                if (bean2 instanceof AbstractStep) {
                    ((AbstractStep)bean2).setObservationRegistry(observationRegistry);
                }
            }
        }
        catch (NoSuchBeanDefinitionException e) {
            LOGGER.info("No Micrometer observation registry found, defaulting to ObservationRegistry.NOOP");
        }
        return bean2;
    }
}

