/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.configuration.xml;

import java.util.Arrays;
import java.util.List;
import org.springframework.batch.core.configuration.xml.CoreNamespaceUtils;
import org.springframework.batch.core.configuration.xml.InlineFlowParser;
import org.springframework.batch.core.configuration.xml.JobExecutionListenerParser;
import org.springframework.batch.core.configuration.xml.JobParserJobFactoryBean;
import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class JobParser
extends AbstractSingleBeanDefinitionParser {
    private static final String MERGE_ATTR = "merge";
    private static final String REF_ATTR = "ref";
    private static final String BEAN_ELE = "bean";
    private static final String REF_ELE = "ref";
    private static final JobExecutionListenerParser jobListenerParser = new JobExecutionListenerParser();

    protected Class<JobParserJobFactoryBean> getBeanClass(Element element) {
        return JobParserJobFactoryBean.class;
    }

    @Override
    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        List<Element> listenersElements;
        String incrementer;
        String restartableAttribute;
        Element validator;
        String repositoryAttribute;
        if (!CoreNamespaceUtils.namespaceMatchesVersion(element)) {
            parserContext.getReaderContext().error("You are using a version of the spring-batch XSD that is not compatible with Spring Batch 3.0.  Please upgrade your schema declarations (or use the spring-batch.xsd alias if you are feeling lucky).", element);
            return;
        }
        CoreNamespaceUtils.autoregisterBeansForNamespace(parserContext, parserContext.extractSource(element));
        String jobName = element.getAttribute("id");
        builder.addConstructorArgValue(jobName);
        boolean isAbstract = CoreNamespaceUtils.isAbstract(element);
        builder.setAbstract(isAbstract);
        String parentRef = element.getAttribute("parent");
        if (StringUtils.hasText(parentRef)) {
            builder.setParentName(parentRef);
        }
        if (StringUtils.hasText(repositoryAttribute = element.getAttribute("job-repository"))) {
            builder.addPropertyReference("jobRepository", repositoryAttribute);
        }
        if ((validator = DomUtils.getChildElementByTagName(element, "validator")) != null) {
            builder.addPropertyValue("jobParametersValidator", this.parseBeanElement(validator, parserContext));
        }
        if (StringUtils.hasText(restartableAttribute = element.getAttribute("restartable"))) {
            builder.addPropertyValue("restartable", restartableAttribute);
        }
        if (StringUtils.hasText(incrementer = element.getAttribute("incrementer"))) {
            builder.addPropertyReference("jobParametersIncrementer", incrementer);
        }
        if (isAbstract) {
            for (String tagName : Arrays.asList("step", "decision", "split")) {
                if (DomUtils.getChildElementsByTagName(element, tagName).isEmpty()) continue;
                parserContext.getReaderContext().error("The <" + tagName + "/> element may not appear on a <job/> with abstract=\"true\" [" + jobName + "]", element);
            }
        } else {
            InlineFlowParser flowParser = new InlineFlowParser(jobName, jobName);
            BeanDefinition flowDef = flowParser.parse(element, parserContext);
            builder.addPropertyValue("flow", flowDef);
        }
        Element description = DomUtils.getChildElementByTagName(element, "description");
        if (description != null) {
            builder.getBeanDefinition().setDescription(description.getTextContent());
        }
        if ((listenersElements = DomUtils.getChildElementsByTagName(element, "listeners")).size() == 1) {
            Element listenersElement = listenersElements.get(0);
            CompositeComponentDefinition compositeDef = new CompositeComponentDefinition(listenersElement.getTagName(), parserContext.extractSource(element));
            parserContext.pushContainingComponent(compositeDef);
            ManagedList<AbstractBeanDefinition> listeners = new ManagedList<AbstractBeanDefinition>();
            listeners.setMergeEnabled(listenersElement.hasAttribute(MERGE_ATTR) && Boolean.parseBoolean(listenersElement.getAttribute(MERGE_ATTR)));
            List<Element> listenerElements = DomUtils.getChildElementsByTagName(listenersElement, "listener");
            for (Element listenerElement : listenerElements) {
                listeners.add(jobListenerParser.parse(listenerElement, parserContext));
            }
            builder.addPropertyValue("jobExecutionListeners", listeners);
            parserContext.popAndRegisterContainingComponent();
        } else if (listenersElements.size() > 1) {
            parserContext.getReaderContext().error("The '<listeners/>' element may not appear more than once in a single <job/>.", element);
        }
    }

    public BeanMetadataElement parseBeanElement(Element element, ParserContext parserContext) {
        String refAttribute = element.getAttribute("ref");
        Element beanElement = DomUtils.getChildElementByTagName(element, BEAN_ELE);
        Element refElement = DomUtils.getChildElementByTagName(element, "ref");
        if (StringUtils.hasText(refAttribute)) {
            return new RuntimeBeanReference(refAttribute);
        }
        if (beanElement != null) {
            BeanDefinitionHolder beanDefinitionHolder = parserContext.getDelegate().parseBeanDefinitionElement(beanElement);
            parserContext.getDelegate().decorateBeanDefinitionIfRequired(beanElement, beanDefinitionHolder);
            return beanDefinitionHolder;
        }
        if (refElement != null) {
            return (BeanMetadataElement)parserContext.getDelegate().parsePropertySubElement(refElement, null);
        }
        parserContext.getReaderContext().error("One of ref attribute or a nested bean definition or ref element must be specified", element);
        return null;
    }
}

