/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.configuration.xml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.springframework.batch.core.job.flow.Flow;
import org.springframework.batch.core.job.flow.FlowExecutionStatus;
import org.springframework.batch.core.job.flow.FlowExecutor;
import org.springframework.batch.core.job.flow.FlowHolder;
import org.springframework.batch.core.job.flow.State;
import org.springframework.batch.core.job.flow.support.SimpleFlow;
import org.springframework.batch.core.job.flow.support.StateTransition;
import org.springframework.batch.core.job.flow.support.state.AbstractState;
import org.springframework.batch.core.job.flow.support.state.StepState;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class SimpleFlowFactoryBean
implements FactoryBean<SimpleFlow>,
InitializingBean {
    private String name;
    private List<StateTransition> stateTransitions;
    private String prefix;
    private Comparator<StateTransition> stateTransitionComparator;
    private Class<SimpleFlow> flowType;

    public void setStateTransitionComparator(Comparator<StateTransition> stateTransitionComparator) {
        this.stateTransitionComparator = stateTransitionComparator;
    }

    public void setFlowType(Class<SimpleFlow> flowType) {
        this.flowType = flowType;
    }

    public void setName(String name) {
        this.name = name;
        this.prefix = name + ".";
    }

    public void setStateTransitions(List<StateTransition> stateTransitions) {
        this.stateTransitions = stateTransitions;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        Assert.state(StringUtils.hasText(this.name), "The flow must have a name");
        if (this.flowType == null) {
            this.flowType = SimpleFlow.class;
        }
    }

    @Override
    public SimpleFlow getObject() throws Exception {
        SimpleFlow flow = this.flowType.getConstructor(String.class).newInstance(this.name);
        flow.setStateTransitionComparator(this.stateTransitionComparator);
        ArrayList<StateTransition> updatedTransitions = new ArrayList<StateTransition>();
        for (StateTransition stateTransition : this.stateTransitions) {
            State state = this.getProxyState(stateTransition.getState());
            updatedTransitions.add(StateTransition.switchOriginAndDestination(stateTransition, state, this.getNext(stateTransition.getNext())));
        }
        flow.setStateTransitions(updatedTransitions);
        flow.afterPropertiesSet();
        return flow;
    }

    private String getNext(String next) {
        if (next == null) {
            return null;
        }
        return (next.startsWith(this.prefix) ? "" : this.prefix) + next;
    }

    private State getProxyState(State state) {
        String oldName = state.getName();
        if (oldName.startsWith(this.prefix)) {
            return state;
        }
        String stateName = this.prefix + oldName;
        if (state instanceof StepState) {
            return this.createNewStepState(state, oldName, stateName);
        }
        return new DelegateState(stateName, state);
    }

    protected State createNewStepState(State state, String oldName, String stateName) {
        return new StepState(stateName, ((StepState)state).getStep(oldName));
    }

    @Override
    public Class<?> getObjectType() {
        return SimpleFlow.class;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    public static class DelegateState
    extends AbstractState
    implements FlowHolder {
        private final State state;

        private DelegateState(String name, State state) {
            super(name);
            this.state = state;
        }

        public State getState() {
            return this.state;
        }

        @Override
        public boolean isEndState() {
            return this.state.isEndState();
        }

        @Override
        public FlowExecutionStatus handle(FlowExecutor executor) throws Exception {
            return this.state.handle(executor);
        }

        @Override
        public Collection<Flow> getFlows() {
            return this.state instanceof FlowHolder ? ((FlowHolder)((Object)this.state)).getFlows() : Collections.emptyList();
        }
    }
}

