/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.launch.support;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.launch.support.ExitCodeMapper;

public class SimpleJvmExitCodeMapper
implements ExitCodeMapper {
    protected Log logger = LogFactory.getLog(this.getClass());
    private final Map<String, Integer> mapping = new HashMap<String, Integer>();

    public SimpleJvmExitCodeMapper() {
        this.mapping.put(ExitStatus.COMPLETED.getExitCode(), 0);
        this.mapping.put(ExitStatus.FAILED.getExitCode(), 1);
        this.mapping.put("JOB_NOT_PROVIDED", 2);
        this.mapping.put("NO_SUCH_JOB", 2);
    }

    public Map<String, Integer> getMapping() {
        return this.mapping;
    }

    public void setMapping(Map<String, Integer> exitCodeMap) {
        this.mapping.putAll(exitCodeMap);
    }

    @Override
    public int intValue(String exitCode) {
        Integer statusCode = null;
        try {
            statusCode = this.mapping.get(exitCode);
        }
        catch (RuntimeException ex) {
            this.logger.fatal("Error mapping exit code, generic exit status returned.", ex);
        }
        return statusCode != null ? statusCode : 1;
    }
}

